/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119.internal.zertsummary;

import java.util.HashMap;
import java.util.Map;

enum SSHAuthMethod {
    UNKNOWN(0),
    NONE(1),
    PASSWORD(2),
    PUBLIC_KEY(3),
    HOST_BASED(4),
    RHOSTS(5),
    RHOSTS_RSA(6),
    RSA(7),
    KEYB_INT(8),
    CHAL_RESP(9),
    CNTL_SOCK1(10),
    GSSAPI_MIC(11),
    GSSAPI_KEX(12),
    NOT_DEFINED(-16);

    private static Map<Integer, SSHAuthMethod> valueMap;
    private final int sshauthmethod;

    private SSHAuthMethod(int sshauthmethod) {
        this.sshauthmethod = sshauthmethod;
    }

    public static SSHAuthMethod from(int value) {
        SSHAuthMethod result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int sshauthmethod() {
        return this.sshauthmethod;
    }

    static {
        valueMap = new HashMap<Integer, SSHAuthMethod>();
        for (SSHAuthMethod x : SSHAuthMethod.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.sshauthmethod, x);
        }
    }
}

