/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf121;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf121.GarbageCollectorSection;
import com.blackhillsoftware.smf.smf121.JavaRuntimeSection;
import com.blackhillsoftware.smf.smf121.ThreadSection;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

public final class Smf121Record
extends SmfRecord {
    private List<JavaRuntimeSection> m_JavaRuntimeSection = null;
    private List<GarbageCollectorSection> m_GarbageCollectorSection = null;
    private List<ThreadSection> m_ThreadSection = null;
    public static final int SMF121RTY_121 = 121;
    public static final int SMF121STY_1 = 1;

    public Smf121Record(byte[] data) {
        super(data);
        if (this.recordType() != 121) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf121Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 121) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf121Record from(SmfRecord record) {
        return new Smf121Record(record);
    }

    public static Smf121Record from(byte[] data) {
        return new Smf121Record(data);
    }

    public List<JavaRuntimeSection> javaRuntimeSections() {
        this.m_JavaRuntimeSection = Util.sectionsFromTriplet(this.m_JavaRuntimeSection, this.data, () -> this.smf121sdsOffjrs(), () -> this.smf121sdsLenjrs(), () -> this.smf121sdsNumjrs(), JavaRuntimeSection::create);
        return this.m_JavaRuntimeSection;
    }

    public List<GarbageCollectorSection> garbageCollectorSections() {
        this.m_GarbageCollectorSection = Util.sectionsFromTriplet(this.m_GarbageCollectorSection, this.data, () -> this.smf121sdsOffgcs(), () -> this.smf121sdsLengcs(), () -> this.smf121sdsNumgcs(), GarbageCollectorSection::create);
        return this.m_GarbageCollectorSection;
    }

    public List<ThreadSection> threadSections() {
        this.m_ThreadSection = Util.sectionsFromTriplet(this.m_ThreadSection, this.data, () -> this.smf121sdsOffts(), () -> this.smf121sdsLents(), () -> this.smf121sdsNumts(), ThreadSection::create);
        return this.m_ThreadSection;
    }

    public int smf121len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf121seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf121flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf121rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf121tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf121tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf121dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf121dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf121sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf121ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf121sty() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf121sdsTriplets() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf121sdsOffjrs() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf121sdsLenjrs() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf121sdsNumjrs() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf121sdsOffgcs() {
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf121sdsLengcs() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf121sdsNumgcs() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf121sdsOffts() {
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf121sdsLents() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf121sdsNumts() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    static enum Field {
        smf121len(0, 2),
        smf121seg(2, 2),
        smf121flg(4, 1),
        smf121rty(5, 1),
        smf121tme(6, 4),
        smf121dte(10, 4),
        smf121sid(14, 4),
        smf121ssi(18, 4),
        smf121sty(22, 2),
        smf121sdsTriplets(24, 2),
        smf121sdsOffjrs(28, 4),
        smf121sdsLenjrs(32, 2),
        smf121sdsNumjrs(34, 2),
        smf121sdsOffgcs(36, 4),
        smf121sdsLengcs(40, 2),
        smf121sdsNumgcs(42, 2),
        smf121sdsOffts(44, 4),
        smf121sdsLents(48, 2),
        smf121sdsNumts(50, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

