/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf14;

import java.util.HashMap;
import java.util.Map;

public enum CompressionType {
    NONE(0),
    GENERIC(1),
    TAILORED(2),
    ZEDC(3),
    NOT_DEFINED(-16);

    private static Map<Integer, CompressionType> valueMap;
    private final int compressiontype;

    private CompressionType(int compressiontype) {
        this.compressiontype = compressiontype;
    }

    public static CompressionType from(int value) {
        CompressionType result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int compressiontype() {
        return this.compressiontype;
    }

    static {
        valueMap = new HashMap<Integer, CompressionType>();
        for (CompressionType x : CompressionType.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.compressiontype, x);
        }
    }
}

