/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf14;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;

public final class DasdExtension
extends SmfData {
    public static final int SMF14EXT = 128;
    public static final int SMF14OPO = 64;
    public static final int SMF14INO = 32;
    public static final int SMF14EPS = 16;
    public static final int SMF14LGE = 128;
    public static final int SMF14EXCPBAM = 64;

    private DasdExtension(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long smf14ntu() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public long smf14ntr() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public int smf14ner() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public int smf14edi() {
        return Util.ConvertUnsignedBinary1(this.data, 9);
    }

    public boolean smf14ext() {
        return Util.ConvertFlag(this.data, this.smf14edi(), 128);
    }

    public boolean smf14opo() {
        return Util.ConvertFlag(this.data, this.smf14edi(), 64);
    }

    public boolean smf14ino() {
        return Util.ConvertFlag(this.data, this.smf14edi(), 32);
    }

    public boolean smf14eps() {
        return Util.ConvertFlag(this.data, this.smf14edi(), 16);
    }

    public int smf14fg1() {
        return Util.ConvertUnsignedBinary1(this.data, 10);
    }

    public boolean smf14lge() {
        return Util.ConvertFlag(this.data, this.smf14fg1(), 128);
    }

    public boolean smf14excpbam() {
        return Util.ConvertFlag(this.data, this.smf14fg1(), 64);
    }

    public LocalDate smf14opd() {
        return Util.SMFDate(this.data, 12);
    }

    public int smf14opdRawValue() {
        return Util.ConvertPacked4(this.data, 12);
    }

    public static DasdExtension create(byte[] Data2, int offset, int length) {
        return new DasdExtension(Data2, offset, length);
    }

    static enum Field {
        smf14ntu(0, 4),
        smf14ntr(4, 4),
        smf14ner(8, 1),
        smf14edi(9, 1),
        smf14fg1(10, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

