/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf14;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class EncryptedDasdDatasetSection
extends SmfData {
    public static final int SMF14DSENC = 128;
    public static final int SMF14DSEB = 64;
    public static final int SMF14DSENCNP = 32;
    public static final int SMF14ENCDASDL = 67;

    private EncryptedDasdDatasetSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf14def() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean smf14dsenc() {
        return Util.ConvertFlag(this.data, this.smf14def(), 128);
    }

    public boolean smf14dseb() {
        return Util.ConvertFlag(this.data, this.smf14def(), 64);
    }

    public boolean smf14dsencnp() {
        return Util.ConvertFlag(this.data, this.smf14def(), 32);
    }

    public int smf14det() {
        return Util.ConvertUnsignedBinary2(this.data, 1);
    }

    public int smf14dea() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public String smf14dkl() {
        return Util.ConvertEbcdic(this.data, 3, 64);
    }

    public static EncryptedDasdDatasetSection create(byte[] Data2, int offset, int length) {
        return new EncryptedDasdDatasetSection(Data2, offset, length);
    }

    static enum Field {
        smf14def(0, 1),
        smf14det(1, 2),
        smf14dea(1, 1),
        smf14dkl(3, 64);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

