/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf19;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Smf19Record
extends SmfRecord {
    public static final int SMF19HDR = 0;
    public static final int SMF19CYM = 128;
    public static final int SMF19E = 132;
    public static final int SMF19L = 132;

    public Smf19Record(byte[] data) {
        super(data);
        if (this.recordType() != 19) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf19Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 19) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf19Record from(SmfRecord record) {
        return new Smf19Record(record);
    }

    public static Smf19Record from(byte[] data) {
        return new Smf19Record(data);
    }

    public int smf19len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf19seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf19flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf19rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf19tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf19tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf19dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf19dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf19sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf19vol() {
        return Util.ConvertEbcdic(this.data, 20, 6);
    }

    public String smf19oid() {
        return Util.ConvertEbcdic(this.data, 26, 10);
    }

    public long smf19dev() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long smf19vtc() {
        return Util.ConvertUnsignedBinary5(this.data, 40);
    }

    public int smf19vti() {
        return Util.ConvertUnsignedBinary1(this.data, 45);
    }

    public int smf19nds() {
        return Util.ConvertUnsignedBinary2(this.data, 46);
    }

    public int smf19dsr() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf19nat() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public long smf19spc() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long smf19lex() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public int smf19nue() {
        return Util.ConvertUnsignedBinary2(this.data, 60);
    }

    public int smf19fl1() {
        return Util.ConvertUnsignedBinary1(this.data, 62);
    }

    public boolean smf19cym() {
        return Util.ConvertFlag(this.data, this.smf19fl1(), 128);
    }

    public int smf19fl2() {
        return Util.ConvertUnsignedBinary1(this.data, 63);
    }

    public int smf19cuu() {
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf19ind() {
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public long smf19sds() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long smf19sl0() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public byte[] smf19evf() {
        if (this.data.length >= 104) {
            byte[] result = new byte[20];
            System.arraycopy(this.data, 84, result, 0, 20);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(84) + " Data length: " + Integer.toString(20));
    }

    public long smf19suc() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long smf19sut() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long smf19snc() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long smf19snt() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long smf19sne() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public byte[] smf19tmf() {
        if (this.data.length >= 124) {
            byte[] result = new byte[20];
            System.arraycopy(this.data, 104, result, 0, 20);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(104) + " Data length: " + Integer.toString(20));
    }

    public long smf19buc() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long smf19but() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long smf19bnc() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public long smf19bnt() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public long smf19bne() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public byte[] smf19vli() {
        if (this.data.length >= 132) {
            byte[] result = new byte[8];
            System.arraycopy(this.data, 124, result, 0, 8);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(124) + " Data length: " + Integer.toString(8));
    }

    public long smf19trk() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public long smf19trm() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    static enum Field {
        smf19len(0, 2),
        smf19seg(2, 2),
        smf19flg(4, 1),
        smf19rty(5, 1),
        smf19tme(6, 4),
        smf19dte(10, 4),
        smf19sid(14, 4),
        smf19vol(20, 6),
        smf19oid(26, 10),
        smf19dev(36, 4),
        smf19vtc(40, 5),
        smf19vti(45, 1),
        smf19nds(46, 2),
        smf19dsr(48, 2),
        smf19nat(50, 2),
        smf19spc(52, 4),
        smf19lex(56, 4),
        smf19nue(60, 2),
        smf19fl1(62, 1),
        smf19fl2(63, 1),
        smf19cuu(64, 2),
        smf19ind(66, 2),
        smf19sds(72, 4),
        smf19sl0(76, 4),
        smf19evf(84, 20),
        smf19suc(84, 4),
        smf19sut(88, 4),
        smf19snc(92, 4),
        smf19snt(96, 4),
        smf19sne(100, 4),
        smf19tmf(104, 20),
        smf19buc(104, 4),
        smf19but(108, 4),
        smf19bnc(112, 4),
        smf19bnt(116, 4),
        smf19bne(120, 4),
        smf19vli(124, 8),
        smf19trk(124, 4),
        smf19trm(128, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

