/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf23;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;

public final class LogstreamStatisticsSection
extends SmfData {
    public static final int SMF23BWG = 128;
    public static final int SMF23DWG = 64;
    public static final int SMF23CRQ = 32;
    public static final int SMF23CPR = 16;
    public static final int SMF23CMP = 8;
    public static final int SMF23PFG = 4;

    private LogstreamStatisticsSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf23lsl() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public String smf23lsn() {
        if (this.data.length >= 2 + this.smf23lsl()) {
            return Util.ConvertEbcdic(this.data, 2, this.smf23lsl());
        }
        return null;
    }

    public long smf23lfa() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long smf23lft() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long smf23lfh() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long smf23lfm() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long smf23lfl() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long smf23lfg() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public boolean smf23bwg() {
        return Util.ConvertFlag(this.data, this.smf23lfg(), 128L);
    }

    public boolean smf23dwg() {
        return Util.ConvertFlag(this.data, this.smf23lfg(), 64L);
    }

    public boolean smf23crq() {
        return Util.ConvertFlag(this.data, this.smf23lfg(), 32L);
    }

    public boolean smf23cpr() {
        return Util.ConvertFlag(this.data, this.smf23lfg(), 16L);
    }

    public boolean smf23cmp() {
        return Util.ConvertFlag(this.data, this.smf23lfg(), 8L);
    }

    public boolean smf23pfg() {
        return Util.ConvertFlag(this.data, this.smf23lfg(), 4L);
    }

    public long smf23pft() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long smf23pfm() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long smf23pfh() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public byte[] smf23cnt() {
        if (this.data.length >= 72) {
            byte[] result = new byte[8];
            System.arraycopy(this.data, 64, result, 0, 8);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(64) + " Data length: " + Integer.toString(8));
    }

    public long smf23cwn() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long smf23ncn() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long smf23bbc() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger smf23bbcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long smf23bac() {
        return Util.ConvertUnsignedBinary8(this.data, 80);
    }

    public BigInteger smf23bacAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public long smf23lhp() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long smf23lcp() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public static LogstreamStatisticsSection create(byte[] Data2, int offset, int length) {
        return new LogstreamStatisticsSection(Data2, offset, length);
    }

    static enum Field {
        smf23lsl(0, 2),
        smf23lsn(2, 0),
        smf23lfa(28, 4),
        smf23lft(32, 4),
        smf23lfh(36, 4),
        smf23lfm(40, 4),
        smf23lfl(44, 4),
        smf23lfg(48, 4),
        smf23pft(52, 4),
        smf23pfm(56, 4),
        smf23pfh(60, 4),
        smf23cnt(64, 8),
        smf23cwn(64, 4),
        smf23ncn(68, 4),
        smf23bbc(72, 8),
        smf23bac(80, 8),
        smf23lhp(88, 4),
        smf23lcp(92, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

