/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf23;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;

public final class SmfStatisticsSection
extends SmfData {
    public static final int SMF23GRF = 128;
    public static final int SMF23PBF = 64;
    public static final int SMF23FRF = 32;
    public static final int SMF23PFF = 16;
    public static final int SMF231FF = 8;
    public static final int SMF23NFF = 4;
    public static final int SMF23IOF = 2;
    public static final int SMF23TCF = 1;
    public static final int SMF23SRF = 128;

    private SmfStatisticsSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long smf23bfw() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public long smf23bfq() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long smf23sus() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long smf23rcw() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf23bfa() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smf23bft() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smf23bfh() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long smf23bfm() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long smf23bfl() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long smf23sfg() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public boolean smf23grf() {
        return Util.ConvertFlag(this.data, this.smf23sfg(), 128, Field.smf23sfg.length, 0);
    }

    public boolean smf23pbf() {
        return Util.ConvertFlag(this.data, this.smf23sfg(), 64, Field.smf23sfg.length, 0);
    }

    public boolean smf23frf() {
        return Util.ConvertFlag(this.data, this.smf23sfg(), 32, Field.smf23sfg.length, 0);
    }

    public boolean smf23pff() {
        return Util.ConvertFlag(this.data, this.smf23sfg(), 16, Field.smf23sfg.length, 0);
    }

    public boolean smf231ff() {
        return Util.ConvertFlag(this.data, this.smf23sfg(), 8, Field.smf23sfg.length, 0);
    }

    public boolean smf23nff() {
        return Util.ConvertFlag(this.data, this.smf23sfg(), 4, Field.smf23sfg.length, 0);
    }

    public boolean smf23iof() {
        return Util.ConvertFlag(this.data, this.smf23sfg(), 2, Field.smf23sfg.length, 0);
    }

    public boolean smf23tcf() {
        return Util.ConvertFlag(this.data, this.smf23sfg(), 1, Field.smf23sfg.length, 0);
    }

    public boolean smf23srf() {
        return Util.ConvertFlag(this.data, this.smf23sfg(), 128, Field.smf23sfg.length, 1);
    }

    public long smf23ngr() {
        return Util.ConvertUnsignedBinary8(this.data, 40);
    }

    public BigInteger smf23ngrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public long smf23pbg() {
        return Util.ConvertUnsignedBinary8(this.data, 48);
    }

    public BigInteger smf23pbgAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long smf23nfr() {
        return Util.ConvertUnsignedBinary8(this.data, 56);
    }

    public BigInteger smf23nfrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public long smf23pfx() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger smf23pfxAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long smf231rf() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger smf231rfAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long smf23nrf() {
        return Util.ConvertUnsignedBinary8(this.data, 80);
    }

    public BigInteger smf23nrfAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public long smf23nio() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger smf23nioAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public long smf23tcb() {
        return Util.ConvertUnsignedBinary8(this.data, 96);
    }

    public BigInteger smf23tcbAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public long smf23srb() {
        return Util.ConvertUnsignedBinary8(this.data, 104);
    }

    public BigInteger smf23srbAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 104);
    }

    public long smf23ngd() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public long smf23pbd() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public long smf23nfd() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public long smf23pfd() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public long smf231rd() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    public long smf23nrd() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public long smf23nid() {
        return Util.ConvertUnsignedBinary8(this.data, 136);
    }

    public BigInteger smf23nidAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 136);
    }

    public long smf23tcd() {
        return Util.ConvertUnsignedBinary8(this.data, 144);
    }

    public BigInteger smf23tcdAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 144);
    }

    public long smf23srd() {
        return Util.ConvertUnsignedBinary8(this.data, 152);
    }

    public BigInteger smf23srdAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 152);
    }

    public long smf23mbu() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public static SmfStatisticsSection create(byte[] Data2, int offset, int length) {
        return new SmfStatisticsSection(Data2, offset, length);
    }

    static enum Field {
        smf23bfw(0, 4),
        smf23bfq(4, 4),
        smf23sus(8, 4),
        smf23rcw(12, 4),
        smf23bfa(16, 4),
        smf23bft(20, 4),
        smf23bfh(24, 4),
        smf23bfm(28, 4),
        smf23bfl(32, 4),
        smf23sfg(36, 4),
        smf23ngr(40, 8),
        smf23pbg(48, 8),
        smf23nfr(56, 8),
        smf23pfx(64, 8),
        smf231rf(72, 8),
        smf23nrf(80, 8),
        smf23nio(88, 8),
        smf23tcb(96, 8),
        smf23srb(104, 8),
        smf23ngd(112, 4),
        smf23pbd(116, 4),
        smf23nfd(120, 4),
        smf23pfd(124, 4),
        smf231rd(128, 4),
        smf23nrd(132, 4),
        smf23nid(136, 8),
        smf23tcd(144, 8),
        smf23srd(152, 8),
        smf23mbu(160, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

