/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf30;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;

public final class CounterSection
extends SmfData {
    public static final int SMF30_InstCaptDisruption = 128;
    public static final int SMF30_InstCaptLimited = 64;

    private CounterSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf30InstFlgs1() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    @Deprecated
    public int smf30Instflgs1() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean smf30InstCaptDisruption() {
        return Util.ConvertFlag(this.data, this.smf30InstFlgs1(), 128);
    }

    @Deprecated
    public boolean smf30Instcaptdisruption() {
        return Util.ConvertFlag(this.data, this.smf30InstFlgs1(), 128);
    }

    public boolean smf30InstCaptLimited() {
        return Util.ConvertFlag(this.data, this.smf30InstFlgs1(), 64);
    }

    @Deprecated
    public boolean smf30Instcaptlimited() {
        return Util.ConvertFlag(this.data, this.smf30InstFlgs1(), 64);
    }

    public long smf30InstCpTask() {
        return Util.ConvertUnsignedBinary8(this.data, 8);
    }

    public BigInteger smf30InstCpTaskAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public long smf30InstCpNonPreemptSrb() {
        return Util.ConvertUnsignedBinary8(this.data, 16);
    }

    public BigInteger smf30InstCpNonPreemptSrbAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public long smf30InstCpPreemptSrb() {
        return Util.ConvertUnsignedBinary8(this.data, 24);
    }

    public BigInteger smf30InstCpPreemptSrbAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public long smf30InstOffload() {
        return Util.ConvertUnsignedBinary8(this.data, 32);
    }

    public BigInteger smf30InstOffloadAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public long smf30InstOffloadOnCp() {
        return Util.ConvertUnsignedBinary8(this.data, 40);
    }

    public BigInteger smf30InstOffloadOnCpAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public long smf30InstCpEnclave() {
        return Util.ConvertUnsignedBinary8(this.data, 48);
    }

    public BigInteger smf30InstCpEnclaveAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long smf30InstOffloadEnclave() {
        return Util.ConvertUnsignedBinary8(this.data, 56);
    }

    public BigInteger smf30InstOffloadEnclaveAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public long smf30InstOffloadOnCpEnclave() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger smf30InstOffloadOnCpEnclaveAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long smf30InstCpDepEnc() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger smf30InstCpDepEncAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long smf30InstOffloadDepEnc() {
        return Util.ConvertUnsignedBinary8(this.data, 80);
    }

    public BigInteger smf30InstOffloadDepEncAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public long smf30InstOffloadOnCpDepEnc() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger smf30InstOffloadOnCpDepEncAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public static CounterSection create(byte[] Data2, int offset, int length) {
        return new CounterSection(Data2, offset, length);
    }

    static enum Field {
        smf30InstFlgs1(0, 1),
        smf30InstCpTask(8, 8),
        smf30InstCpNonPreemptSrb(16, 8),
        smf30InstCpPreemptSrb(24, 8),
        smf30InstOffload(32, 8),
        smf30InstOffloadOnCp(40, 8),
        smf30InstCpEnclave(48, 8),
        smf30InstOffloadEnclave(56, 8),
        smf30InstOffloadOnCpEnclave(64, 8),
        smf30InstCpDepEnc(72, 8),
        smf30InstOffloadDepEnc(80, 8),
        smf30InstOffloadOnCpDepEnc(88, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

