/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf30;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class PerformanceSection
extends SmfData {
    public static final int SMF30PFJ = 128;
    public static final int SMF30PFR = 64;
    public static final int SMF30PFF = 32;
    public static final int SMF30RTR = 16;
    public static final int SMF30MSI = 8;
    public static final int SMF30WMI = 4;
    public static final int SMF30CCP = 2;
    public static final int SMF30CSP = 1;
    public static final int SMF30ASP = 128;
    public static final int SMF30SME = 64;
    public static final int SMF30CPR = 32;
    public static final int SMF30SPR = 16;
    public static final int SMF30PIN = 8;
    public static final int SMF30CRM = 4;
    public static final int SMF30SRV_INV = 128;
    public static final int SMF30CSU_INV = 64;
    public static final int SMF30SRB_INV = 32;
    public static final int SMF30IO_INV = 16;
    public static final int SMF30MSO_INV = 8;
    public static final int SMF30ESU_INV = 4;
    public static final int SMF30LGA = 128;
    public static final int SMF30P1A = 64;
    public static final int SMF30_Event_Driven_Intvl_Rec = 128;
    public static final int SMF30_RQSVSUS_Err = 64;
    public static final int SMF30_Capacity_Data_err = 32;
    public static final int SMF30_PCD_Rsvd_Exists = 16;

    private PerformanceSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long smf30srv() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public long smf30csu() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long smf30srb() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long smf30io() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf30mso() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public Duration smf30tat() {
        return Util.Binary4x1024MS(this.data, 20);
    }

    public double smf30tatSeconds() {
        return Util.ToSeconds(this.smf30tat());
    }

    public long smf30tatRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smf30sus() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public Duration smf30res() {
        return Util.Binary4x1024MS(this.data, 28);
    }

    public double smf30resSeconds() {
        return Util.ToSeconds(this.smf30res());
    }

    public long smf30resRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long smf30trs() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public String smf30wlm() {
        return Util.ConvertEbcdic(this.data, 36, 8);
    }

    public String smf30scn() {
        return Util.ConvertEbcdic(this.data, 44, 8);
    }

    public String smf30grn() {
        return Util.ConvertEbcdic(this.data, 52, 8);
    }

    public String smf30rcn() {
        return Util.ConvertEbcdic(this.data, 60, 8);
    }

    public Duration smf30eta() {
        return Util.Binary4x1024MS(this.data, 68);
    }

    public double smf30etaSeconds() {
        return Util.ToSeconds(this.smf30eta());
    }

    public long smf30etaRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long smf30esu() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long smf30etc() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public String smf30pfl() {
        return Util.ConvertEbcdic(this.data, 80, 16);
    }

    public Duration smf30jqt() {
        return Util.Binary4x1024MS(this.data, 96);
    }

    public double smf30jqtSeconds() {
        return Util.ToSeconds(this.smf30jqt());
    }

    public long smf30jqtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public Duration smf30rqt() {
        return Util.Binary4x1024MS(this.data, 100);
    }

    public double smf30rqtSeconds() {
        return Util.ToSeconds(this.smf30rqt());
    }

    public long smf30rqtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public Duration smf30hqt() {
        return Util.Binary4x1024MS(this.data, 104);
    }

    public double smf30hqtSeconds() {
        return Util.ToSeconds(this.smf30hqt());
    }

    public long smf30hqtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public Duration smf30sqt() {
        return Util.Binary4x1024MS(this.data, 108);
    }

    public double smf30sqtSeconds() {
        return Util.ToSeconds(this.smf30sqt());
    }

    public long smf30sqtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public int smf30pf1() {
        return Util.ConvertUnsignedBinary1(this.data, 112);
    }

    public boolean smf30pfj() {
        return Util.ConvertFlag(this.data, this.smf30pf1(), 128);
    }

    public boolean smf30pfr() {
        return Util.ConvertFlag(this.data, this.smf30pf1(), 64);
    }

    public boolean smf30pff() {
        return Util.ConvertFlag(this.data, this.smf30pf1(), 32);
    }

    public boolean smf30rtr() {
        return Util.ConvertFlag(this.data, this.smf30pf1(), 16);
    }

    public boolean smf30msi() {
        return Util.ConvertFlag(this.data, this.smf30pf1(), 8);
    }

    public boolean smf30wmi() {
        return Util.ConvertFlag(this.data, this.smf30pf1(), 4);
    }

    public boolean smf30ccp() {
        return Util.ConvertFlag(this.data, this.smf30pf1(), 2);
    }

    public boolean smf30csp() {
        return Util.ConvertFlag(this.data, this.smf30pf1(), 1);
    }

    public int smf30pf2() {
        return Util.ConvertUnsignedBinary1(this.data, 113);
    }

    public boolean smf30asp() {
        return Util.ConvertFlag(this.data, this.smf30pf2(), 128);
    }

    public boolean smf30sme() {
        return Util.ConvertFlag(this.data, this.smf30pf2(), 64);
    }

    public boolean smf30cpr() {
        return Util.ConvertFlag(this.data, this.smf30pf2(), 32);
    }

    public boolean smf30spr() {
        return Util.ConvertFlag(this.data, this.smf30pf2(), 16);
    }

    public boolean smf30pin() {
        return Util.ConvertFlag(this.data, this.smf30pf2(), 8);
    }

    public boolean smf30crm() {
        return Util.ConvertFlag(this.data, this.smf30pf2(), 4);
    }

    public int smf30inv() {
        return Util.ConvertUnsignedBinary1(this.data, 114);
    }

    public boolean smf30srvInv() {
        return Util.ConvertFlag(this.data, this.smf30inv(), 128);
    }

    public boolean smf30csuInv() {
        return Util.ConvertFlag(this.data, this.smf30inv(), 64);
    }

    public boolean smf30srbInv() {
        return Util.ConvertFlag(this.data, this.smf30inv(), 32);
    }

    public boolean smf30ioInv() {
        return Util.ConvertFlag(this.data, this.smf30inv(), 16);
    }

    public boolean smf30msoInv() {
        return Util.ConvertFlag(this.data, this.smf30inv(), 8);
    }

    public boolean smf30esuInv() {
        return Util.ConvertFlag(this.data, this.smf30inv(), 4);
    }

    public int smf30zep() {
        return Util.ConvertUnsignedBinary1(this.data, 115);
    }

    public String smf30jpn() {
        return Util.ConvertEbcdic(this.data, 116, 8);
    }

    public long smf30msc() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public int smf30cpc() {
        return Util.ConvertUnsignedBinary2(this.data, 128);
    }

    public int smf30loc() {
        return Util.ConvertUnsignedBinary2(this.data, 130);
    }

    public int smf30src() {
        return Util.ConvertUnsignedBinary2(this.data, 132);
    }

    public int smf30znf() {
        return Util.ConvertUnsignedBinary2(this.data, 134);
    }

    public int smf30snf() {
        return Util.ConvertUnsignedBinary2(this.data, 136);
    }

    public long smf30srvL() {
        return Util.ConvertUnsignedBinary8(this.data, 144);
    }

    public BigInteger smf30srvLAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 144);
    }

    public long smf30csuL() {
        return Util.ConvertUnsignedBinary8(this.data, 152);
    }

    public BigInteger smf30csuLAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 152);
    }

    public long smf30srbL() {
        return Util.ConvertUnsignedBinary8(this.data, 160);
    }

    public BigInteger smf30srbLAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 160);
    }

    public long smf30ioL() {
        return Util.ConvertUnsignedBinary8(this.data, 168);
    }

    public BigInteger smf30ioLAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 168);
    }

    public long smf30msoL() {
        return Util.ConvertUnsignedBinary8(this.data, 176);
    }

    public BigInteger smf30msoLAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 176);
    }

    public long smf30esuL() {
        return Util.ConvertUnsignedBinary8(this.data, 184);
    }

    public BigInteger smf30esuLAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 184);
    }

    public int smf30acb() {
        return Util.ConvertUnsignedBinary1(this.data, 192);
    }

    public boolean smf30lga() {
        return Util.ConvertFlag(this.data, this.smf30acb(), 128);
    }

    public boolean smf30p1a() {
        return Util.ConvertFlag(this.data, this.smf30acb(), 64);
    }

    public int smf30cr() {
        return Util.ConvertUnsignedBinary1(this.data, 193);
    }

    public int smf30CapacityChangeCnt() {
        return Util.ConvertUnsignedBinary2(this.data, 194);
    }

    public long smf30RctpcpuaActual() {
        return Util.ConvertUnsignedBinary4(this.data, 196);
    }

    public long smf30RctpcpuaNominal() {
        return Util.ConvertUnsignedBinary4(this.data, 200);
    }

    public long smf30RctpcpuaScalingFactor() {
        return Util.ConvertUnsignedBinary4(this.data, 204);
    }

    public int smf30CapacityAdjustmentInd() {
        return Util.ConvertUnsignedBinary1(this.data, 208);
    }

    public int smf30CapacityChangeRsn() {
        return Util.ConvertUnsignedBinary1(this.data, 209);
    }

    public int smf30CapacityFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 210);
    }

    public boolean smf30EventDrivenIntvlRec() {
        return Util.ConvertFlag(this.data, this.smf30CapacityFlags(), 128);
    }

    public boolean smf30RqsvsusErr() {
        return Util.ConvertFlag(this.data, this.smf30CapacityFlags(), 64);
    }

    public boolean smf30CapacityDataErr() {
        return Util.ConvertFlag(this.data, this.smf30CapacityFlags(), 32);
    }

    public boolean smf30PcdRsvdExists() {
        return Util.ConvertFlag(this.data, this.smf30CapacityFlags(), 16);
    }

    public long smf30RmctadjnNominal() {
        return Util.ConvertUnsignedBinary4(this.data, 212);
    }

    public static PerformanceSection create(byte[] Data2, int offset, int length) {
        return new PerformanceSection(Data2, offset, length);
    }

    static enum Field {
        smf30srv(0, 4),
        smf30csu(4, 4),
        smf30srb(8, 4),
        smf30io(12, 4),
        smf30mso(16, 4),
        smf30tat(20, 4),
        smf30sus(24, 4),
        smf30res(28, 4),
        smf30trs(32, 4),
        smf30wlm(36, 8),
        smf30scn(44, 8),
        smf30grn(52, 8),
        smf30rcn(60, 8),
        smf30eta(68, 4),
        smf30esu(72, 4),
        smf30etc(76, 4),
        smf30pfl(80, 16),
        smf30jqt(96, 4),
        smf30rqt(100, 4),
        smf30hqt(104, 4),
        smf30sqt(108, 4),
        smf30pf1(112, 1),
        smf30pf2(113, 1),
        smf30inv(114, 1),
        smf30zep(115, 1),
        smf30jpn(116, 8),
        smf30msc(124, 4),
        smf30cpc(128, 2),
        smf30loc(130, 2),
        smf30src(132, 2),
        smf30znf(134, 2),
        smf30snf(136, 2),
        smf30srvL(144, 8),
        smf30csuL(152, 8),
        smf30srbL(160, 8),
        smf30ioL(168, 8),
        smf30msoL(176, 8),
        smf30esuL(184, 8),
        smf30acb(192, 1),
        smf30cr(193, 1),
        smf30CapacityChangeCnt(194, 2),
        smf30RctpcpuaActual(196, 4),
        smf30RctpcpuaNominal(200, 4),
        smf30RctpcpuaScalingFactor(204, 4),
        smf30CapacityAdjustmentInd(208, 1),
        smf30CapacityChangeRsn(209, 1),
        smf30CapacityFlags(210, 1),
        smf30RmctadjnNominal(212, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

