/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf30;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class SubsystemSection
extends SmfData {
    public static final int SMF30_zCBP = 128;
    public static final int SMF30_CrypCtrs_Active = 64;
    public static final int SMF30_NNPICtrs_Active = 32;

    private SubsystemSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf30typ() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf30pflags() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public boolean smf30Zcbp() {
        return Util.ConvertFlag(this.data, this.smf30pflags(), 128);
    }

    public boolean smf30CrypCtrsActive() {
        return Util.ConvertFlag(this.data, this.smf30pflags(), 64);
    }

    public boolean smf30NnpiCtrsActive() {
        return Util.ConvertFlag(this.data, this.smf30pflags(), 32);
    }

    public String smf30rvn() {
        return Util.ConvertEbcdic(this.data, 4, 2);
    }

    public String smf30pnm() {
        return Util.ConvertEbcdic(this.data, 6, 8);
    }

    public String smf30osl() {
        return Util.ConvertEbcdic(this.data, 14, 8);
    }

    public String smf30syn() {
        return Util.ConvertEbcdic(this.data, 22, 8);
    }

    public String smf30syp() {
        return Util.ConvertEbcdic(this.data, 30, 8);
    }

    public static SubsystemSection create(byte[] Data2, int offset, int length) {
        return new SubsystemSection(Data2, offset, length);
    }

    static enum Field {
        smf30typ(0, 2),
        smf30pflags(3, 1),
        smf30rvn(4, 2),
        smf30pnm(6, 8),
        smf30osl(14, 8),
        smf30syn(22, 8),
        smf30syp(30, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

