/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf30;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class UsageDataSection
extends SmfData {
    public static final int SMF30UUN = 128;

    private UsageDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Duration smf30urdCpuTime() {
        if (this.smf30udf() != 1) {
            throw new NotAvailableException("Value is only available if (smf30udf() == 1)");
        }
        return Util.LongFpHex_x100S(this.data, Field.smf30urd.offset());
    }

    public double smf30urdFloatingPoint() {
        if (this.smf30udf() != 3) {
            throw new NotAvailableException("Value is only available if (smf30udf() == 3)");
        }
        return Util.ConvertLongFPHex(this.data, Field.smf30urd.offset());
    }

    public long smf30urdBinary() {
        if (this.smf30udf() != 2) {
            throw new NotAvailableException("Value is only available if (smf30udf() == 2)");
        }
        return Util.ConvertUnsignedBinary8(this.data, Field.smf30urd.offset());
    }

    public BigInteger smf30urdBigInteger() {
        if (this.smf30udf() != 2) {
            throw new NotAvailableException("Value is only available if (smf30udf() == 2)");
        }
        return Util.ConvertUnsignedBinary8BigInteger(this.data, Field.smf30urd.offset());
    }

    public String smf30upo() {
        return Util.ConvertEbcdic(this.data, 0, 16);
    }

    public String smf30upn() {
        return Util.ConvertEbcdic(this.data, 16, 16);
    }

    public String smf30upv() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public String smf30upq() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public String smf30upi() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public Duration smf30uct() {
        return Util.Binary4x100S(this.data, 56);
    }

    public double smf30uctSeconds() {
        return Util.ToSeconds(this.smf30uct());
    }

    public long smf30uctRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public Duration smf30ucs() {
        return Util.Binary4x100S(this.data, 60);
    }

    public double smf30ucsSeconds() {
        return Util.ToSeconds(this.smf30ucs());
    }

    public long smf30ucsRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public byte[] smf30urd() {
        if (this.data.length >= 72) {
            byte[] result = new byte[8];
            System.arraycopy(this.data, 64, result, 0, 8);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(64) + " Data length: " + Integer.toString(8));
    }

    public int smf30udf() {
        return Util.ConvertUnsignedBinary1(this.data, 72);
    }

    public int smf30ufg() {
        return Util.ConvertUnsignedBinary1(this.data, 73);
    }

    public boolean smf30uun() {
        return Util.ConvertFlag(this.data, this.smf30ufg(), 128);
    }

    public static UsageDataSection create(byte[] Data2, int offset, int length) {
        return new UsageDataSection(Data2, offset, length);
    }

    static enum Field {
        smf30upo(0, 16),
        smf30upn(16, 16),
        smf30upv(32, 8),
        smf30upq(40, 8),
        smf30upi(48, 8),
        smf30uct(56, 4),
        smf30ucs(60, 4),
        smf30urd(64, 8),
        smf30udf(72, 1),
        smf30ufg(73, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

