/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype11;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf42.subtype11.XrcSsidData;
import com.blackhillsoftware.smf.smf42.subtype11.XrcVolumeData;
import java.util.ArrayList;
import java.util.List;

public final class XrcSession
extends SmfData {
    private List<XrcSsidData> m_XrcSsidData = new ArrayList<XrcSsidData>();
    private List<XrcVolumeData> m_XrcVolumeData = null;
    public static final int SMF420BA_LEN = 32;

    private XrcSession(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
        SmfData current;
        if (this.s42xrssn() != 0) {
            current = XrcSsidData.create(Data2, this.s42xrsso(), this.s42xrssl());
            this.m_XrcSsidData.add((XrcSsidData)current);
            while (((XrcSsidData)current).s42xrsnx() != 0) {
                current = XrcSsidData.create(Data2, ((XrcSsidData)current).s42xrsnx(), this.s42xrssl());
                this.m_XrcSsidData.add((XrcSsidData)current);
            }
        }
        this.m_XrcVolumeData = new ArrayList<XrcVolumeData>();
        if (this.s42xrvln() != 0) {
            current = XrcVolumeData.create(Data2, this.s42xrvlo(), this.s42xrvll());
            this.m_XrcVolumeData.add((XrcVolumeData)current);
            while (((XrcVolumeData)current).s42xrvlx() != 0) {
                current = XrcVolumeData.create(Data2, ((XrcVolumeData)current).s42xrvlx(), this.s42xrvll());
                this.m_XrcVolumeData.add((XrcVolumeData)current);
            }
        }
    }

    public String s42xrid() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String s42xrtyp() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public int s42xrsso() {
        return Util.ConvertSignedBinary4(this.data, 16);
    }

    public int s42xrssn() {
        return Util.ConvertUnsignedBinary2(this.data, 20);
    }

    public int s42xrssl() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int s42xrvlo() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    public int s42xrvln() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int s42xrvll() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public List<XrcSsidData> xrcSsidData() {
        return this.m_XrcSsidData;
    }

    public List<XrcVolumeData> xrcVolumeData() {
        return this.m_XrcVolumeData;
    }

    public static XrcSession create(byte[] Data2, int offset, int length) {
        return new XrcSession(Data2, offset, length);
    }

    static enum Field {
        s42xrid(0, 8),
        s42xrtyp(8, 8),
        s42xrsso(16, 4),
        s42xrssn(20, 2),
        s42xrssl(22, 2),
        s42xrvlo(24, 4),
        s42xrvln(28, 2),
        s42xrvll(30, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

