/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype11;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class XrcSsidData
extends SmfData {
    public static final int S42XRSSD_LEN = 44;

    private XrcSsidData(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int s42xrsnx() {
        return Util.ConvertSignedBinary4(this.data, 0);
    }

    public int s42xrsid() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public int s42xridp() {
        return Util.ConvertUnsignedBinary1(this.data, 6);
    }

    public long s42xrvsh() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long s42xrtpr() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long s42xrnwd() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long s42xrnnd() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long s42xrnlr() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long s42xrnfw() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long s42xrnuw() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long s42xrars() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public static XrcSsidData create(byte[] Data2, int offset, int length) {
        return new XrcSsidData(Data2, offset, length);
    }

    static enum Field {
        s42xrsnx(0, 4),
        s42xrsid(4, 2),
        s42xridp(6, 1),
        s42xrvsh(8, 4),
        s42xrtpr(12, 4),
        s42xrnwd(16, 4),
        s42xrnnd(20, 4),
        s42xrnlr(24, 4),
        s42xrnfw(28, 4),
        s42xrnuw(32, 4),
        s42xrars(36, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

