/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype16;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class DatasetSummaryAboveBar
extends SmfData {
    public static final int SMF2AGAI0 = Integer.MIN_VALUE;
    public static final int SMF2AGAI1 = 0x40000000;
    public static final int SMF2AGA3_LEN = 168;
    public static final int SMF2AGA4_LEN = 168;
    public static final int SMF2AGA2_LEN = 336;
    public static final int SMF2AGA6_LEN = 168;
    public static final int SMF2AGA7_LEN = 168;
    public static final int SMF2AGA8_LEN = 168;
    public static final int SMF2AGA9_LEN = 168;
    public static final int SMF2AGA5_LEN = 672;
    public static final int SMF2AFX5_LEN = 128;
    public static final int SMF2AFX7_LEN = 64;
    public static final int SMF2A0GA_LEN = 1488;

    private DatasetSummaryAboveBar(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Duration smf2agaa() {
        return Util.Binary4_Seconds(this.data, 0);
    }

    public double smf2agaaSeconds() {
        return Util.ToSeconds(this.smf2agaa());
    }

    public long smf2agaaRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public String smf2agab() {
        return Util.ConvertEbcdic(this.data, 16, 44);
    }

    public String smf2agac() {
        return Util.ConvertEbcdic(this.data, 64, 44);
    }

    public int smf2agad() {
        return Util.ConvertUnsignedBinary2(this.data, 112);
    }

    public String smf2agae() {
        if (this.data.length >= 114 + this.smf2agad()) {
            return Util.ConvertEbcdic(this.data, 114, this.smf2agad());
        }
        return null;
    }

    public int smf2aa03() {
        return Util.ConvertUnsignedBinary2(this.data, 144);
    }

    public String smf2agaf() {
        if (this.data.length >= 146 + this.smf2aa03()) {
            return Util.ConvertEbcdic(this.data, 146, this.smf2aa03());
        }
        return null;
    }

    public String smf2agah() {
        return Util.ConvertEbcdic(this.data, 178, 30);
    }

    public long smf2agai() {
        return Util.ConvertUnsignedBinary4(this.data, 208);
    }

    public boolean smf2agai0() {
        return Util.ConvertFlag(this.data, this.smf2agai(), Integer.MIN_VALUE);
    }

    public boolean smf2agai1() {
        return Util.ConvertFlag(this.data, this.smf2agai(), 0x40000000L);
    }

    public String smf2agaj() {
        return Util.ConvertEbcdic(this.data, 212, 12);
    }

    public long smf2agak() {
        return Util.ConvertUnsignedBinary4(this.data, 224);
    }

    public long smf2agal() {
        return Util.ConvertUnsignedBinary4(this.data, 228);
    }

    public long smf2agam() {
        return Util.ConvertUnsignedBinary4(this.data, 232);
    }

    public int smf2agz1() {
        return Util.ConvertUnsignedBinary2(this.data, 236);
    }

    public int smf2agz2() {
        return Util.ConvertUnsignedBinary2(this.data, 238);
    }

    public String smf2agan() {
        return Util.ConvertEbcdic(this.data, 240, 8);
    }

    public String smf2agao() {
        return Util.ConvertEbcdic(this.data, 248, 8);
    }

    public String smf2agap() {
        return Util.ConvertEbcdic(this.data, 256, 16);
    }

    public long smf2agca() {
        return Util.ConvertUnsignedBinary4(this.data, 272);
    }

    public long smf2agcb() {
        return Util.ConvertUnsignedBinary4(this.data, 276);
    }

    public long smf2agcc() {
        return Util.ConvertUnsignedBinary4(this.data, 280);
    }

    public long smf2agcd() {
        return Util.ConvertUnsignedBinary4(this.data, 284);
    }

    public long smf2agce() {
        return Util.ConvertUnsignedBinary4(this.data, 288);
    }

    public long smf2agcf() {
        return Util.ConvertUnsignedBinary4(this.data, 292);
    }

    public long smf2agcg() {
        return Util.ConvertUnsignedBinary4(this.data, 296);
    }

    public long smf2agch() {
        return Util.ConvertUnsignedBinary4(this.data, 300);
    }

    public long smf2agci() {
        return Util.ConvertUnsignedBinary4(this.data, 304);
    }

    public long smf2agcj() {
        return Util.ConvertUnsignedBinary4(this.data, 308);
    }

    public long smf2agck() {
        return Util.ConvertUnsignedBinary4(this.data, 312);
    }

    public long smf2agcl() {
        return Util.ConvertUnsignedBinary4(this.data, 316);
    }

    public long smf2agcm() {
        return Util.ConvertUnsignedBinary4(this.data, 320);
    }

    public long smf2agcn() {
        return Util.ConvertUnsignedBinary4(this.data, 324);
    }

    public long smf2agco() {
        return Util.ConvertUnsignedBinary4(this.data, 328);
    }

    public long smf2agcp() {
        return Util.ConvertUnsignedBinary4(this.data, 332);
    }

    public long smf2agcq() {
        return Util.ConvertUnsignedBinary8(this.data, 336);
    }

    public BigInteger smf2agcqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 336);
    }

    public long smf2agcr() {
        return Util.ConvertUnsignedBinary4(this.data, 344);
    }

    public long smf2agcs() {
        return Util.ConvertUnsignedBinary4(this.data, 348);
    }

    public long smf2agct() {
        return Util.ConvertUnsignedBinary8(this.data, 352);
    }

    public BigInteger smf2agctAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 352);
    }

    public long smf2agcu() {
        return Util.ConvertUnsignedBinary8(this.data, 360);
    }

    public BigInteger smf2agcuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 360);
    }

    public Duration smf2agcw() {
        return Util.Binary8MSSeconds(this.data, 384);
    }

    public double smf2agcwSeconds() {
        return Util.ToSeconds(this.smf2agcw());
    }

    public BigInteger smf2agcwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 384);
    }

    public Duration smf2agcx() {
        return Util.Binary4MS(this.data, 392);
    }

    public double smf2agcxSeconds() {
        return Util.ToSeconds(this.smf2agcx());
    }

    public long smf2agcxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 392);
    }

    public Duration smf2agcy() {
        return Util.Binary4MS(this.data, 396);
    }

    public double smf2agcySeconds() {
        return Util.ToSeconds(this.smf2agcy());
    }

    public long smf2agcyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 396);
    }

    public long smf2agda() {
        return Util.ConvertUnsignedBinary4(this.data, 440);
    }

    public long smf2agdb() {
        return Util.ConvertUnsignedBinary4(this.data, 444);
    }

    public long smf2agdc() {
        return Util.ConvertUnsignedBinary4(this.data, 448);
    }

    public long smf2agdd() {
        return Util.ConvertUnsignedBinary4(this.data, 452);
    }

    public long smf2agde() {
        return Util.ConvertUnsignedBinary4(this.data, 456);
    }

    public long smf2agdf() {
        return Util.ConvertUnsignedBinary4(this.data, 460);
    }

    public long smf2agdg() {
        return Util.ConvertUnsignedBinary4(this.data, 464);
    }

    public long smf2agdh() {
        return Util.ConvertUnsignedBinary4(this.data, 468);
    }

    public long smf2agdi() {
        return Util.ConvertUnsignedBinary4(this.data, 472);
    }

    public long smf2agdj() {
        return Util.ConvertUnsignedBinary4(this.data, 476);
    }

    public long smf2agdk() {
        return Util.ConvertUnsignedBinary4(this.data, 480);
    }

    public long smf2agdl() {
        return Util.ConvertUnsignedBinary4(this.data, 484);
    }

    public long smf2agdm() {
        return Util.ConvertUnsignedBinary4(this.data, 488);
    }

    public long smf2agdn() {
        return Util.ConvertUnsignedBinary4(this.data, 492);
    }

    public long smf2agdo() {
        return Util.ConvertUnsignedBinary4(this.data, 496);
    }

    public long smf2agdp() {
        return Util.ConvertUnsignedBinary4(this.data, 500);
    }

    public long smf2agdq() {
        return Util.ConvertUnsignedBinary8(this.data, 504);
    }

    public BigInteger smf2agdqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 504);
    }

    public long smf2agdr() {
        return Util.ConvertUnsignedBinary4(this.data, 512);
    }

    public long smf2agds() {
        return Util.ConvertUnsignedBinary4(this.data, 516);
    }

    public long smf2agdt() {
        return Util.ConvertUnsignedBinary8(this.data, 520);
    }

    public BigInteger smf2agdtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 520);
    }

    public long smf2agdu() {
        return Util.ConvertUnsignedBinary8(this.data, 528);
    }

    public BigInteger smf2agduAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 528);
    }

    public Duration smf2agdw() {
        return Util.Binary8MSSeconds(this.data, 552);
    }

    public double smf2agdwSeconds() {
        return Util.ToSeconds(this.smf2agdw());
    }

    public BigInteger smf2agdwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 552);
    }

    public Duration smf2agdx() {
        return Util.Binary4MS(this.data, 560);
    }

    public double smf2agdxSeconds() {
        return Util.ToSeconds(this.smf2agdx());
    }

    public long smf2agdxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 560);
    }

    public Duration smf2agdy() {
        return Util.Binary4MS(this.data, 564);
    }

    public double smf2agdySeconds() {
        return Util.ToSeconds(this.smf2agdy());
    }

    public long smf2agdyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 564);
    }

    public long smf2agea() {
        return Util.ConvertUnsignedBinary4(this.data, 608);
    }

    public long smf2ageb() {
        return Util.ConvertUnsignedBinary4(this.data, 612);
    }

    public long smf2agec() {
        return Util.ConvertUnsignedBinary4(this.data, 616);
    }

    public long smf2aged() {
        return Util.ConvertUnsignedBinary4(this.data, 620);
    }

    public long smf2agee() {
        return Util.ConvertUnsignedBinary4(this.data, 624);
    }

    public long smf2agef() {
        return Util.ConvertUnsignedBinary4(this.data, 628);
    }

    public long smf2ageg() {
        return Util.ConvertUnsignedBinary4(this.data, 632);
    }

    public long smf2ageh() {
        return Util.ConvertUnsignedBinary4(this.data, 636);
    }

    public long smf2agei() {
        return Util.ConvertUnsignedBinary4(this.data, 640);
    }

    public long smf2agej() {
        return Util.ConvertUnsignedBinary4(this.data, 644);
    }

    public long smf2agek() {
        return Util.ConvertUnsignedBinary4(this.data, 648);
    }

    public long smf2agel() {
        return Util.ConvertUnsignedBinary4(this.data, 652);
    }

    public long smf2agem() {
        return Util.ConvertUnsignedBinary4(this.data, 656);
    }

    public long smf2agen() {
        return Util.ConvertUnsignedBinary4(this.data, 660);
    }

    public long smf2ageo() {
        return Util.ConvertUnsignedBinary4(this.data, 664);
    }

    public long smf2agep() {
        return Util.ConvertUnsignedBinary4(this.data, 668);
    }

    public long smf2ageq() {
        return Util.ConvertUnsignedBinary8(this.data, 672);
    }

    public BigInteger smf2ageqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 672);
    }

    public long smf2ager() {
        return Util.ConvertUnsignedBinary4(this.data, 680);
    }

    public long smf2ages() {
        return Util.ConvertUnsignedBinary4(this.data, 684);
    }

    public long smf2aget() {
        return Util.ConvertUnsignedBinary8(this.data, 688);
    }

    public BigInteger smf2agetAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 688);
    }

    public long smf2ageu() {
        return Util.ConvertUnsignedBinary8(this.data, 696);
    }

    public BigInteger smf2ageuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 696);
    }

    public Duration smf2agew() {
        return Util.Binary8MSSeconds(this.data, 720);
    }

    public double smf2agewSeconds() {
        return Util.ToSeconds(this.smf2agew());
    }

    public BigInteger smf2agewRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 720);
    }

    public Duration smf2agex() {
        return Util.Binary4MS(this.data, 728);
    }

    public double smf2agexSeconds() {
        return Util.ToSeconds(this.smf2agex());
    }

    public long smf2agexRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 728);
    }

    public Duration smf2agey() {
        return Util.Binary4MS(this.data, 732);
    }

    public double smf2ageySeconds() {
        return Util.ToSeconds(this.smf2agey());
    }

    public long smf2ageyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 732);
    }

    public long smf2agfa() {
        return Util.ConvertUnsignedBinary4(this.data, 776);
    }

    public long smf2agfb() {
        return Util.ConvertUnsignedBinary4(this.data, 780);
    }

    public long smf2agfc() {
        return Util.ConvertUnsignedBinary4(this.data, 784);
    }

    public long smf2agfd() {
        return Util.ConvertUnsignedBinary4(this.data, 788);
    }

    public long smf2agfe() {
        return Util.ConvertUnsignedBinary4(this.data, 792);
    }

    public long smf2agff() {
        return Util.ConvertUnsignedBinary4(this.data, 796);
    }

    public long smf2agfg() {
        return Util.ConvertUnsignedBinary4(this.data, 800);
    }

    public long smf2agfh() {
        return Util.ConvertUnsignedBinary4(this.data, 804);
    }

    public long smf2agfi() {
        return Util.ConvertUnsignedBinary4(this.data, 808);
    }

    public long smf2agfj() {
        return Util.ConvertUnsignedBinary4(this.data, 812);
    }

    public long smf2agfk() {
        return Util.ConvertUnsignedBinary4(this.data, 816);
    }

    public long smf2agfl() {
        return Util.ConvertUnsignedBinary4(this.data, 820);
    }

    public long smf2agfm() {
        return Util.ConvertUnsignedBinary4(this.data, 824);
    }

    public long smf2agfn() {
        return Util.ConvertUnsignedBinary4(this.data, 828);
    }

    public long smf2agfo() {
        return Util.ConvertUnsignedBinary4(this.data, 832);
    }

    public long smf2agfp() {
        return Util.ConvertUnsignedBinary4(this.data, 836);
    }

    public long smf2agfq() {
        return Util.ConvertUnsignedBinary8(this.data, 840);
    }

    public BigInteger smf2agfqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 840);
    }

    public long smf2agfr() {
        return Util.ConvertUnsignedBinary4(this.data, 848);
    }

    public long smf2agfs() {
        return Util.ConvertUnsignedBinary4(this.data, 852);
    }

    public long smf2agft() {
        return Util.ConvertUnsignedBinary8(this.data, 856);
    }

    public BigInteger smf2agftAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 856);
    }

    public long smf2agfu() {
        return Util.ConvertUnsignedBinary8(this.data, 864);
    }

    public BigInteger smf2agfuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 864);
    }

    public Duration smf2agfw() {
        return Util.Binary8MSSeconds(this.data, 888);
    }

    public double smf2agfwSeconds() {
        return Util.ToSeconds(this.smf2agfw());
    }

    public BigInteger smf2agfwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 888);
    }

    public Duration smf2agfx() {
        return Util.Binary4MS(this.data, 896);
    }

    public double smf2agfxSeconds() {
        return Util.ToSeconds(this.smf2agfx());
    }

    public long smf2agfxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 896);
    }

    public Duration smf2agfy() {
        return Util.Binary4MS(this.data, 900);
    }

    public double smf2agfySeconds() {
        return Util.ToSeconds(this.smf2agfy());
    }

    public long smf2agfyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 900);
    }

    public long smf2agga() {
        return Util.ConvertUnsignedBinary4(this.data, 944);
    }

    public long smf2aggb() {
        return Util.ConvertUnsignedBinary4(this.data, 948);
    }

    public long smf2aggc() {
        return Util.ConvertUnsignedBinary4(this.data, 952);
    }

    public long smf2aggd() {
        return Util.ConvertUnsignedBinary4(this.data, 956);
    }

    public long smf2agge() {
        return Util.ConvertUnsignedBinary4(this.data, 960);
    }

    public long smf2aggf() {
        return Util.ConvertUnsignedBinary4(this.data, 964);
    }

    public long smf2aggg() {
        return Util.ConvertUnsignedBinary4(this.data, 968);
    }

    public long smf2aggh() {
        return Util.ConvertUnsignedBinary4(this.data, 972);
    }

    public long smf2aggi() {
        return Util.ConvertUnsignedBinary4(this.data, 976);
    }

    public long smf2aggj() {
        return Util.ConvertUnsignedBinary4(this.data, 980);
    }

    public long smf2aggk() {
        return Util.ConvertUnsignedBinary4(this.data, 984);
    }

    public long smf2aggl() {
        return Util.ConvertUnsignedBinary4(this.data, 988);
    }

    public long smf2aggm() {
        return Util.ConvertUnsignedBinary4(this.data, 992);
    }

    public long smf2aggn() {
        return Util.ConvertUnsignedBinary4(this.data, 996);
    }

    public long smf2aggo() {
        return Util.ConvertUnsignedBinary4(this.data, 1000);
    }

    public long smf2aggp() {
        return Util.ConvertUnsignedBinary4(this.data, 1004);
    }

    public long smf2aggq() {
        return Util.ConvertUnsignedBinary8(this.data, 1008);
    }

    public BigInteger smf2aggqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1008);
    }

    public long smf2aggr() {
        return Util.ConvertUnsignedBinary4(this.data, 1016);
    }

    public long smf2aggs() {
        return Util.ConvertUnsignedBinary4(this.data, 1020);
    }

    public long smf2aggt() {
        return Util.ConvertUnsignedBinary8(this.data, 1024);
    }

    public BigInteger smf2aggtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1024);
    }

    public long smf2aggu() {
        return Util.ConvertUnsignedBinary8(this.data, 1032);
    }

    public BigInteger smf2agguAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1032);
    }

    public Duration smf2aggw() {
        return Util.Binary8MSSeconds(this.data, 1056);
    }

    public double smf2aggwSeconds() {
        return Util.ToSeconds(this.smf2aggw());
    }

    public BigInteger smf2aggwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1056);
    }

    public Duration smf2aggx() {
        return Util.Binary4MS(this.data, 1064);
    }

    public double smf2aggxSeconds() {
        return Util.ToSeconds(this.smf2aggx());
    }

    public long smf2aggxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 1064);
    }

    public Duration smf2aggy() {
        return Util.Binary4MS(this.data, 1068);
    }

    public double smf2aggySeconds() {
        return Util.ToSeconds(this.smf2aggy());
    }

    public long smf2aggyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 1068);
    }

    public long smf2agha() {
        return Util.ConvertUnsignedBinary4(this.data, 1112);
    }

    public long smf2aghb() {
        return Util.ConvertUnsignedBinary4(this.data, 1116);
    }

    public long smf2aghc() {
        return Util.ConvertUnsignedBinary4(this.data, 1120);
    }

    public long smf2aghd() {
        return Util.ConvertUnsignedBinary4(this.data, 1124);
    }

    public long smf2aghe() {
        return Util.ConvertUnsignedBinary4(this.data, 1128);
    }

    public long smf2aghf() {
        return Util.ConvertUnsignedBinary4(this.data, 1132);
    }

    public long smf2aghg() {
        return Util.ConvertUnsignedBinary4(this.data, 1136);
    }

    public long smf2aghh() {
        return Util.ConvertUnsignedBinary4(this.data, 1140);
    }

    public long smf2aghi() {
        return Util.ConvertUnsignedBinary4(this.data, 1144);
    }

    public long smf2aghj() {
        return Util.ConvertUnsignedBinary4(this.data, 1148);
    }

    public long smf2aghk() {
        return Util.ConvertUnsignedBinary4(this.data, 1152);
    }

    public long smf2aghl() {
        return Util.ConvertUnsignedBinary4(this.data, 1156);
    }

    public long smf2aghm() {
        return Util.ConvertUnsignedBinary4(this.data, 1160);
    }

    public long smf2aghn() {
        return Util.ConvertUnsignedBinary4(this.data, 1164);
    }

    public long smf2agho() {
        return Util.ConvertUnsignedBinary4(this.data, 1168);
    }

    public long smf2aghp() {
        return Util.ConvertUnsignedBinary4(this.data, 1172);
    }

    public long smf2aghq() {
        return Util.ConvertUnsignedBinary8(this.data, 1176);
    }

    public BigInteger smf2aghqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1176);
    }

    public long smf2aghr() {
        return Util.ConvertUnsignedBinary4(this.data, 1184);
    }

    public long smf2aghs() {
        return Util.ConvertUnsignedBinary4(this.data, 1188);
    }

    public long smf2aght() {
        return Util.ConvertUnsignedBinary8(this.data, 1192);
    }

    public BigInteger smf2aghtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1192);
    }

    public long smf2aghu() {
        return Util.ConvertUnsignedBinary8(this.data, 1200);
    }

    public BigInteger smf2aghuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1200);
    }

    public Duration smf2aghw() {
        return Util.Binary8MSSeconds(this.data, 1224);
    }

    public double smf2aghwSeconds() {
        return Util.ToSeconds(this.smf2aghw());
    }

    public BigInteger smf2aghwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1224);
    }

    public Duration smf2aghx() {
        return Util.Binary4MS(this.data, 1232);
    }

    public double smf2aghxSeconds() {
        return Util.ToSeconds(this.smf2aghx());
    }

    public long smf2aghxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 1232);
    }

    public Duration smf2aghy() {
        return Util.Binary4MS(this.data, 1236);
    }

    public double smf2aghySeconds() {
        return Util.ToSeconds(this.smf2aghy());
    }

    public long smf2aghyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 1236);
    }

    public long smf2agpa() {
        return Util.ConvertUnsignedBinary4(this.data, 1280);
    }

    public long smf2agpb() {
        return Util.ConvertUnsignedBinary4(this.data, 1284);
    }

    public long smf2agpc() {
        return Util.ConvertUnsignedBinary4(this.data, 1288);
    }

    public long smf2agpd() {
        return Util.ConvertUnsignedBinary4(this.data, 1292);
    }

    public long smf2agpe() {
        return Util.ConvertUnsignedBinary4(this.data, 1296);
    }

    public long smf2agpf() {
        return Util.ConvertUnsignedBinary4(this.data, 1300);
    }

    public long smf42guaa() {
        return Util.ConvertUnsignedBinary4(this.data, 1304);
    }

    public long smf42guba() {
        return Util.ConvertUnsignedBinary4(this.data, 1308);
    }

    public long smf2agph() {
        return Util.ConvertUnsignedBinary4(this.data, 1312);
    }

    public long smf2agpi() {
        return Util.ConvertUnsignedBinary4(this.data, 1316);
    }

    public long smf2agpj() {
        return Util.ConvertUnsignedBinary4(this.data, 1320);
    }

    public long smf2agpk() {
        return Util.ConvertUnsignedBinary4(this.data, 1324);
    }

    public long smf2agpl() {
        return Util.ConvertUnsignedBinary4(this.data, 1328);
    }

    public long smf2agpm() {
        return Util.ConvertUnsignedBinary4(this.data, 1332);
    }

    public long smf2agpn() {
        return Util.ConvertUnsignedBinary4(this.data, 1336);
    }

    public long smf2agpo() {
        return Util.ConvertUnsignedBinary4(this.data, 1340);
    }

    public long smf2agpp() {
        return Util.ConvertUnsignedBinary4(this.data, 1344);
    }

    public long smf2agpq() {
        return Util.ConvertUnsignedBinary4(this.data, 1348);
    }

    public long smf2agpr() {
        return Util.ConvertUnsignedBinary4(this.data, 1352);
    }

    public long smf2agps() {
        return Util.ConvertUnsignedBinary4(this.data, 1356);
    }

    public long smf2agpt() {
        return Util.ConvertUnsignedBinary4(this.data, 1360);
    }

    public long smf2agpu() {
        return Util.ConvertUnsignedBinary4(this.data, 1364);
    }

    public long smf2agpv() {
        return Util.ConvertUnsignedBinary4(this.data, 1368);
    }

    public long smf2agpw() {
        return Util.ConvertUnsignedBinary4(this.data, 1372);
    }

    public long smf42guda() {
        return Util.ConvertUnsignedBinary4(this.data, 1376);
    }

    public long smf42guea() {
        return Util.ConvertUnsignedBinary4(this.data, 1380);
    }

    public long smf42gufa() {
        return Util.ConvertUnsignedBinary4(this.data, 1384);
    }

    public long smf42guga() {
        return Util.ConvertUnsignedBinary4(this.data, 1388);
    }

    public long smf42gsha() {
        return Util.ConvertUnsignedBinary4(this.data, 1392);
    }

    public long smf42gsia() {
        return Util.ConvertUnsignedBinary4(this.data, 1396);
    }

    public long smf42gsja() {
        return Util.ConvertUnsignedBinary4(this.data, 1400);
    }

    public long smf42gska() {
        return Util.ConvertUnsignedBinary4(this.data, 1404);
    }

    public long smf2agra() {
        return Util.ConvertUnsignedBinary4(this.data, 1408);
    }

    public long smf2agrb() {
        return Util.ConvertUnsignedBinary4(this.data, 1412);
    }

    public long smf2agrc() {
        return Util.ConvertUnsignedBinary4(this.data, 1416);
    }

    public long smf2agrd() {
        return Util.ConvertUnsignedBinary4(this.data, 1420);
    }

    public long smf2agre() {
        return Util.ConvertUnsignedBinary4(this.data, 1424);
    }

    public long smf2agrg() {
        return Util.ConvertUnsignedBinary4(this.data, 1428);
    }

    public long smf2agrh() {
        return Util.ConvertUnsignedBinary4(this.data, 1432);
    }

    public long smf2agri() {
        return Util.ConvertUnsignedBinary4(this.data, 1436);
    }

    public long smf2agrw() {
        return Util.ConvertUnsignedBinary4(this.data, 1448);
    }

    public long smf2agrj() {
        return Util.ConvertUnsignedBinary4(this.data, 1452);
    }

    public String smf2agy1() {
        return Util.ConvertEbcdic(this.data, 1456, 8);
    }

    public long smf42gsaa() {
        return Util.ConvertUnsignedBinary4(this.data, 1456);
    }

    public long smf42gsba() {
        return Util.ConvertUnsignedBinary4(this.data, 1460);
    }

    public String smf2agaq() {
        return Util.ConvertEbcdic(this.data, 1472, 16);
    }

    public static DatasetSummaryAboveBar create(byte[] Data2, int offset, int length) {
        return new DatasetSummaryAboveBar(Data2, offset, length);
    }

    static enum Field {
        smf2agaa(0, 4),
        smf2agab(16, 44),
        smf2agac(64, 44),
        smf2agad(112, 2),
        smf2agae(114, 0),
        smf2aa03(144, 2),
        smf2agaf(146, 0),
        smf2agah(178, 30),
        smf2agai(208, 4),
        smf2agaj(212, 12),
        smf2agak(224, 4),
        smf2agal(228, 4),
        smf2agam(232, 4),
        smf2agz1(236, 2),
        smf2agz2(238, 2),
        smf2agan(240, 8),
        smf2agao(248, 8),
        smf2agap(256, 16),
        smf2agca(272, 4),
        smf2agcb(276, 4),
        smf2agcc(280, 4),
        smf2agcd(284, 4),
        smf2agce(288, 4),
        smf2agcf(292, 4),
        smf2agcg(296, 4),
        smf2agch(300, 4),
        smf2agci(304, 4),
        smf2agcj(308, 4),
        smf2agck(312, 4),
        smf2agcl(316, 4),
        smf2agcm(320, 4),
        smf2agcn(324, 4),
        smf2agco(328, 4),
        smf2agcp(332, 4),
        smf2agcq(336, 8),
        smf2agcr(344, 4),
        smf2agcs(348, 4),
        smf2agct(352, 8),
        smf2agcu(360, 8),
        smf2agcw(384, 8),
        smf2agcx(392, 4),
        smf2agcy(396, 4),
        smf2agda(440, 4),
        smf2agdb(444, 4),
        smf2agdc(448, 4),
        smf2agdd(452, 4),
        smf2agde(456, 4),
        smf2agdf(460, 4),
        smf2agdg(464, 4),
        smf2agdh(468, 4),
        smf2agdi(472, 4),
        smf2agdj(476, 4),
        smf2agdk(480, 4),
        smf2agdl(484, 4),
        smf2agdm(488, 4),
        smf2agdn(492, 4),
        smf2agdo(496, 4),
        smf2agdp(500, 4),
        smf2agdq(504, 8),
        smf2agdr(512, 4),
        smf2agds(516, 4),
        smf2agdt(520, 8),
        smf2agdu(528, 8),
        smf2agdw(552, 8),
        smf2agdx(560, 4),
        smf2agdy(564, 4),
        smf2agea(608, 4),
        smf2ageb(612, 4),
        smf2agec(616, 4),
        smf2aged(620, 4),
        smf2agee(624, 4),
        smf2agef(628, 4),
        smf2ageg(632, 4),
        smf2ageh(636, 4),
        smf2agei(640, 4),
        smf2agej(644, 4),
        smf2agek(648, 4),
        smf2agel(652, 4),
        smf2agem(656, 4),
        smf2agen(660, 4),
        smf2ageo(664, 4),
        smf2agep(668, 4),
        smf2ageq(672, 8),
        smf2ager(680, 4),
        smf2ages(684, 4),
        smf2aget(688, 8),
        smf2ageu(696, 8),
        smf2agew(720, 8),
        smf2agex(728, 4),
        smf2agey(732, 4),
        smf2agfa(776, 4),
        smf2agfb(780, 4),
        smf2agfc(784, 4),
        smf2agfd(788, 4),
        smf2agfe(792, 4),
        smf2agff(796, 4),
        smf2agfg(800, 4),
        smf2agfh(804, 4),
        smf2agfi(808, 4),
        smf2agfj(812, 4),
        smf2agfk(816, 4),
        smf2agfl(820, 4),
        smf2agfm(824, 4),
        smf2agfn(828, 4),
        smf2agfo(832, 4),
        smf2agfp(836, 4),
        smf2agfq(840, 8),
        smf2agfr(848, 4),
        smf2agfs(852, 4),
        smf2agft(856, 8),
        smf2agfu(864, 8),
        smf2agfw(888, 8),
        smf2agfx(896, 4),
        smf2agfy(900, 4),
        smf2agga(944, 4),
        smf2aggb(948, 4),
        smf2aggc(952, 4),
        smf2aggd(956, 4),
        smf2agge(960, 4),
        smf2aggf(964, 4),
        smf2aggg(968, 4),
        smf2aggh(972, 4),
        smf2aggi(976, 4),
        smf2aggj(980, 4),
        smf2aggk(984, 4),
        smf2aggl(988, 4),
        smf2aggm(992, 4),
        smf2aggn(996, 4),
        smf2aggo(1000, 4),
        smf2aggp(1004, 4),
        smf2aggq(1008, 8),
        smf2aggr(1016, 4),
        smf2aggs(1020, 4),
        smf2aggt(1024, 8),
        smf2aggu(1032, 8),
        smf2aggw(1056, 8),
        smf2aggx(1064, 4),
        smf2aggy(1068, 4),
        smf2agha(1112, 4),
        smf2aghb(1116, 4),
        smf2aghc(1120, 4),
        smf2aghd(1124, 4),
        smf2aghe(1128, 4),
        smf2aghf(1132, 4),
        smf2aghg(1136, 4),
        smf2aghh(1140, 4),
        smf2aghi(1144, 4),
        smf2aghj(1148, 4),
        smf2aghk(1152, 4),
        smf2aghl(1156, 4),
        smf2aghm(1160, 4),
        smf2aghn(1164, 4),
        smf2agho(1168, 4),
        smf2aghp(1172, 4),
        smf2aghq(1176, 8),
        smf2aghr(1184, 4),
        smf2aghs(1188, 4),
        smf2aght(1192, 8),
        smf2aghu(1200, 8),
        smf2aghw(1224, 8),
        smf2aghx(1232, 4),
        smf2aghy(1236, 4),
        smf2agpa(1280, 4),
        smf2agpb(1284, 4),
        smf2agpc(1288, 4),
        smf2agpd(1292, 4),
        smf2agpe(1296, 4),
        smf2agpf(1300, 4),
        smf42guaa(1304, 4),
        smf42guba(1308, 4),
        smf2agph(1312, 4),
        smf2agpi(1316, 4),
        smf2agpj(1320, 4),
        smf2agpk(1324, 4),
        smf2agpl(1328, 4),
        smf2agpm(1332, 4),
        smf2agpn(1336, 4),
        smf2agpo(1340, 4),
        smf2agpp(1344, 4),
        smf2agpq(1348, 4),
        smf2agpr(1352, 4),
        smf2agps(1356, 4),
        smf2agpt(1360, 4),
        smf2agpu(1364, 4),
        smf2agpv(1368, 4),
        smf2agpw(1372, 4),
        smf42guda(1376, 4),
        smf42guea(1380, 4),
        smf42gufa(1384, 4),
        smf42guga(1388, 4),
        smf42gsha(1392, 4),
        smf42gsia(1396, 4),
        smf42gsja(1400, 4),
        smf42gska(1404, 4),
        smf2agra(1408, 4),
        smf2agrb(1412, 4),
        smf2agrc(1416, 4),
        smf2agrd(1420, 4),
        smf2agre(1424, 4),
        smf2agrg(1428, 4),
        smf2agrh(1432, 4),
        smf2agri(1436, 4),
        smf2agrw(1448, 4),
        smf2agrj(1452, 4),
        smf2agy1(1456, 8),
        smf42gsaa(1456, 4),
        smf42gsba(1460, 4),
        smf2agaq(1472, 16);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

