/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype27;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.security.Token;

public final class VtocUpdateSection
extends SmfData {
    public static final int SMF42RRSV = 128;
    public static final int SMF42REOS = 128;
    public static final int SMF42RZRTY = 64;
    public static final int SMF42REOS2 = 32;
    public static final int SMF42REOS3 = 16;
    public static final int SMF42REOS4 = 8;
    private Token m_smf42rutok = null;
    public static final int SMF420RA_LEN = 156;

    private VtocUpdateSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf42rjob() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String smf42rjno() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String smf42rstn() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String smf42rprn() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public String smf42rvol() {
        return Util.ConvertEbcdic(this.data, 32, 6);
    }

    public int smf42rdev() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public String smf42ract() {
        return Util.ConvertEbcdic(this.data, 40, 4);
    }

    public int smf42rind() {
        return Util.ConvertUnsignedBinary1(this.data, 44);
    }

    public boolean smf42rrsv() {
        return Util.ConvertFlag(this.data, this.smf42rind(), 128);
    }

    public int smf42rdsi() {
        return Util.ConvertUnsignedBinary1(this.data, 45);
    }

    public boolean smf42reos() {
        return Util.ConvertFlag(this.data, this.smf42rdsi(), 128);
    }

    public boolean smf42rzrty() {
        return Util.ConvertFlag(this.data, this.smf42rdsi(), 64);
    }

    public boolean smf42reos2() {
        return Util.ConvertFlag(this.data, this.smf42rdsi(), 32);
    }

    public boolean smf42reos3() {
        return Util.ConvertFlag(this.data, this.smf42rdsi(), 16);
    }

    public boolean smf42reos4() {
        return Util.ConvertFlag(this.data, this.smf42rdsi(), 8);
    }

    public long smf42rseek() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long smf42rsrch() {
        return Util.ConvertUnsignedBinary5(this.data, 52);
    }

    public byte[] smf42rcmds() {
        if (this.data.length >= 72) {
            byte[] result = new byte[15];
            System.arraycopy(this.data, 57, result, 0, 15);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(57) + " Data length: " + Integer.toString(15));
    }

    public long smf42rupsw() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public Token smf42rutok() {
        if (this.m_smf42rutok == null) {
            this.m_smf42rutok = new Token(this._smf42rutok());
        }
        return this.m_smf42rutok;
    }

    private byte[] _smf42rutok() {
        if (this.data.length >= 156) {
            byte[] result = new byte[80];
            System.arraycopy(this.data, 76, result, 0, 80);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(76) + " Data length: " + Integer.toString(80));
    }

    public static VtocUpdateSection create(byte[] Data2, int offset, int length) {
        return new VtocUpdateSection(Data2, offset, length);
    }

    static enum Field {
        smf42rjob(0, 8),
        smf42rjno(8, 8),
        smf42rstn(16, 8),
        smf42rprn(24, 8),
        smf42rvol(32, 6),
        smf42rdev(38, 2),
        smf42ract(40, 4),
        smf42rind(44, 1),
        smf42rdsi(45, 1),
        smf42rseek(48, 4),
        smf42rsrch(52, 5),
        smf42rcmds(57, 15),
        smf42rupsw(72, 4),
        smf42rutok(76, 80);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

