/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype4;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class ExtendedSequentialDatasetStatistics
extends SmfData {
    public static final int SMF4204E_LEN = 72;

    private ExtendedSequentialDatasetStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long s42exid() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public String s42exrqs() {
        return Util.ConvertEbcdic(this.data, 4, 3);
    }

    public String s42exjnm() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String s42exjno() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public ZonedDateTime s42exstm() {
        return Util.Binary8xStckTime(this.data, 24);
    }

    public BigInteger s42exstmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public ZonedDateTime s42exetm() {
        return Util.Binary8xStckTime(this.data, 32);
    }

    public BigInteger s42exetmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public String s42exts() {
        return Util.ConvertEbcdic(this.data, 40, 1);
    }

    public long s42evlrt() {
        return Util.ConvertUnsignedBinary8(this.data, 44);
    }

    public BigInteger s42evlrtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 44);
    }

    public long s42evlwt() {
        return Util.ConvertUnsignedBinary8(this.data, 52);
    }

    public BigInteger s42evlwtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public static ExtendedSequentialDatasetStatistics create(byte[] Data2, int offset, int length) {
        return new ExtendedSequentialDatasetStatistics(Data2, offset, length);
    }

    static enum Field {
        s42exid(0, 4),
        s42exrqs(4, 3),
        s42exjnm(8, 8),
        s42exjno(16, 8),
        s42exstm(24, 8),
        s42exetm(32, 8),
        s42exts(40, 1),
        s42evlrt(44, 8),
        s42evlwt(52, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

