/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf64;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf64.ExtentInformationSection;
import com.blackhillsoftware.smf.smf64.StatisticsSection;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Smf64Record
extends SmfRecord {
    public static final int SMF64CLO = 128;
    public static final int SMF64VSW = 64;
    public static final int SMF64OSP = 32;
    public static final int SMF64CAT = 16;
    public static final int SMF64TCL = 8;
    public static final int SMF64ABN = 4;
    public static final int SMF64CTL = 2;
    public static final int SMF64RMC = 1;
    public static final int SMF64DTA = 128;
    public static final int SMF64IDX = 64;
    public static final int SMF64EF = 32;
    public static final int SMF64CMP = 16;
    public static final int SMF64RLS = 8;
    public static final int SMF64DIS = 4;
    public static final int SMF64EA = 2;
    public static final int SMF64SSR = 1;
    private List<ExtentInformationSection> m_ExtentInformationSection = null;
    private StatisticsSection m_StatisticsSection = null;

    public Smf64Record(byte[] data) {
        super(data);
        if (this.recordType() != 64) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf64Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 64) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf64Record from(SmfRecord record) {
        return new Smf64Record(record);
    }

    public static Smf64Record from(byte[] data) {
        return new Smf64Record(data);
    }

    public int smf64len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf64seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf64flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf64rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf64tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf64tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf64dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf64dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf64sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf64jbn() {
        return Util.ConvertEbcdic(this.data, 18, 8);
    }

    public LocalTime smf64rst() {
        return Util.Binary4x100STime(this.data, 26);
    }

    public long smf64rstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 26);
    }

    public LocalDate smf64rsd() {
        return Util.SMFDate(this.data, 30);
    }

    public int smf64rsdRawValue() {
        return Util.ConvertPacked4(this.data, 30);
    }

    public String smf64uif() {
        return Util.ConvertEbcdic(this.data, 34, 8);
    }

    public int smf64rin() {
        return Util.ConvertUnsignedBinary1(this.data, 42);
    }

    public boolean smf64clo() {
        return Util.ConvertFlag(this.data, this.smf64rin(), 128);
    }

    public boolean smf64vsw() {
        return Util.ConvertFlag(this.data, this.smf64rin(), 64);
    }

    public boolean smf64osp() {
        return Util.ConvertFlag(this.data, this.smf64rin(), 32);
    }

    public boolean smf64cat() {
        return Util.ConvertFlag(this.data, this.smf64rin(), 16);
    }

    public boolean smf64tcl() {
        return Util.ConvertFlag(this.data, this.smf64rin(), 8);
    }

    public boolean smf64abn() {
        return Util.ConvertFlag(this.data, this.smf64rin(), 4);
    }

    public boolean smf64ctl() {
        return Util.ConvertFlag(this.data, this.smf64rin(), 2);
    }

    public boolean smf64rmc() {
        return Util.ConvertFlag(this.data, this.smf64rin(), 1);
    }

    public int smf64dty() {
        return Util.ConvertUnsignedBinary1(this.data, 43);
    }

    public boolean smf64dta() {
        return Util.ConvertFlag(this.data, this.smf64dty(), 128);
    }

    public boolean smf64idx() {
        return Util.ConvertFlag(this.data, this.smf64dty(), 64);
    }

    public boolean smf64ef() {
        return Util.ConvertFlag(this.data, this.smf64dty(), 32);
    }

    public boolean smf64cmp() {
        return Util.ConvertFlag(this.data, this.smf64dty(), 16);
    }

    public boolean smf64rls() {
        return Util.ConvertFlag(this.data, this.smf64dty(), 8);
    }

    public boolean smf64dis() {
        return Util.ConvertFlag(this.data, this.smf64dty(), 4);
    }

    public boolean smf64ea() {
        return Util.ConvertFlag(this.data, this.smf64dty(), 2);
    }

    public boolean smf64ssr() {
        return Util.ConvertFlag(this.data, this.smf64dty(), 1);
    }

    public String smf64cnm() {
        return Util.ConvertEbcdic(this.data, 44, 44);
    }

    public String smf64dnm() {
        return Util.ConvertEbcdic(this.data, 88, 44);
    }

    public int smf64ntr() {
        return Util.ConvertUnsignedBinary2(this.data, 132);
    }

    public long smf64chr() {
        return Util.ConvertUnsignedBinary4(this.data, 134);
    }

    public long smf64chc() {
        return Util.ConvertUnsignedBinary4(this.data, 134);
    }

    public int smf64esl() {
        return Util.ConvertUnsignedBinary2(this.data, 138);
    }

    public String smf64jobid() {
        return Util.ConvertEbcdic(this.data, 444, 8);
    }

    public String smf64sysplexName() {
        return Util.ConvertEbcdic(this.data, 452, 8);
    }

    public List<ExtentInformationSection> extentInformationSections() {
        if (this.m_ExtentInformationSection == null) {
            if (this.smf64esl() == 0) {
                this.m_ExtentInformationSection = Collections.emptyList();
            } else {
                this.m_ExtentInformationSection = new ArrayList<ExtentInformationSection>(this.smf64esl() / 26);
                for (int i = 0; i < this.smf64esl() / 26; ++i) {
                    this.m_ExtentInformationSection.add(ExtentInformationSection.create(this.data, Field.smf64esl.offset + Field.smf64esl.length + i * 26, 26));
                }
            }
        }
        return this.m_ExtentInformationSection;
    }

    public StatisticsSection statisticsSection() {
        if (this.m_StatisticsSection == null) {
            int offset = Field.smf64esl.offset + Field.smf64esl.length + this.smf64esl();
            this.m_StatisticsSection = StatisticsSection.create(this.data, offset, this.data.length - offset);
        }
        return this.m_StatisticsSection;
    }

    static enum Field {
        smf64len(0, 2),
        smf64seg(2, 2),
        smf64flg(4, 1),
        smf64rty(5, 1),
        smf64tme(6, 4),
        smf64dte(10, 4),
        smf64sid(14, 4),
        smf64jbn(18, 8),
        smf64rst(26, 4),
        smf64rsd(30, 4),
        smf64uif(34, 8),
        smf64rin(42, 1),
        smf64dty(43, 1),
        smf64cnm(44, 44),
        smf64dnm(88, 44),
        smf64ntr(132, 2),
        smf64chr(134, 4),
        smf64chc(134, 4),
        smf64esl(138, 2),
        smf64jobid(444, 8),
        smf64sysplexName(452, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

