/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf65;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf60.EntryType;
import com.blackhillsoftware.smf.smf65.CatalogRecord;
import com.blackhillsoftware.smf.smf65.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Smf65Record
extends SmfRecord {
    public static final int SMF65SLF = 24;
    public static final int SMF65PRD = 40;
    public static final int SMF65DAT = 50;

    public Smf65Record(byte[] data) {
        super(data);
        this.checkRecord();
    }

    public Smf65Record(SmfRecord record) {
        super(record);
        this.checkRecord();
    }

    public static Smf65Record from(SmfRecord record) {
        return new Smf65Record(record);
    }

    public static Smf65Record from(byte[] data) {
        return new Smf65Record(data);
    }

    private void checkRecord() {
        if (this.recordType() != 65) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
        if (this.smf65pno() > 1) {
            throw new IllegalArgumentException("Multiple product sections found: " + Integer.toString(this.smf65pno()));
        }
        if (this.smf65dno() > 1) {
            throw new IllegalArgumentException("Multiple data sections found: " + Integer.toString(this.smf65dno()));
        }
    }

    public int smf65len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf65seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf65sys() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf65rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf65tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf65tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf65dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf65dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf65cpu() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf65sub() {
        return Util.ConvertEbcdic(this.data, 22, 2);
    }

    public int smf65pof() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    public int smf65pln() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf65pno() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public int smf65dof() {
        return Util.ConvertSignedBinary4(this.data, 32);
    }

    public int smf65dln() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public int smf65dno() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public String smf65ver() {
        return Util.ConvertEbcdic(this.data, 40, 2);
    }

    public String smf65pnm() {
        return Util.ConvertEbcdic(this.data, 42, 8);
    }

    public String smf65jnm() {
        return Util.ConvertEbcdic(this.data, 50, 8);
    }

    public LocalTime smf65rst() {
        return Util.Binary4x100STime(this.data, 58);
    }

    public long smf65rstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 58);
    }

    public LocalDate smf65rdt() {
        return Util.SMFDate(this.data, 62);
    }

    public int smf65rdtRawValue() {
        return Util.ConvertPacked4(this.data, 62);
    }

    public String smf65uid() {
        return Util.ConvertEbcdic(this.data, 66, 8);
    }

    public String smf65fnc() {
        return Util.ConvertEbcdic(this.data, 74, 1);
    }

    public String smf65cnm() {
        return Util.ConvertEbcdic(this.data, 75, 44);
    }

    public int smf65typ() {
        return Util.ConvertUnsignedBinary1(this.data, 119);
    }

    public EntryType smf65EntryType() {
        return EntryType.fromInt(this.smf65typ());
    }

    public String smf65enm() {
        return Util.ConvertEbcdic(this.data, 120, 44);
    }

    public CatalogRecord smf65crc() {
        int offset = this.smf65dof() + this.smf65dln();
        int length = CatalogRecord.smf65crl(this.data, offset);
        return CatalogRecord.create(this.data, offset, length);
    }

    public Timestamp timestamp() {
        int offset = this.smf65dof() + this.smf65dln();
        offset += CatalogRecord.smf65crl(this.data, offset);
        int length = Timestamp.Field.smf65ets.length();
        return Timestamp.create(this.data, offset, length);
    }

    static enum Field {
        smf65len(0, 2),
        smf65seg(2, 2),
        smf65sys(4, 1),
        smf65rty(5, 1),
        smf65tme(6, 4),
        smf65dte(10, 4),
        smf65cpu(14, 4),
        smf65sub(22, 2),
        smf65pof(24, 4),
        smf65pln(28, 2),
        smf65pno(30, 2),
        smf65dof(32, 4),
        smf65dln(36, 2),
        smf65dno(38, 2),
        smf65ver(40, 2),
        smf65pnm(42, 8),
        smf65jnm(50, 8),
        smf65rst(58, 4),
        smf65rdt(62, 4),
        smf65uid(66, 8),
        smf65fnc(74, 1),
        smf65cnm(75, 44),
        smf65typ(119, 1),
        smf65enm(120, 44),
        smf65crc(208, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

