/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf7;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Smf7Record
extends SmfRecord {
    public static final int SMFRCD7 = 0;
    public static final int SMF7NRF = 128;
    public static final int SMF7LSD = 64;
    public static final int SMF7DRP = 32;

    public Smf7Record(byte[] data) {
        super(data);
        if (this.recordType() != 7) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf7Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 7) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf7Record from(SmfRecord record) {
        return new Smf7Record(record);
    }

    public static Smf7Record from(byte[] data) {
        return new Smf7Record(data);
    }

    public int smf7len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf7seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf7flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf7rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf7tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf7tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf7dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf7dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf7sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public int smf7nro() {
        return Util.ConvertUnsignedBinary2(this.data, 18);
    }

    public LocalTime smf7stm() {
        return Util.Binary4x100STime(this.data, 20);
    }

    public long smf7stmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public LocalDate smf7std() {
        return Util.SMFDate(this.data, 24);
    }

    public int smf7stdRawValue() {
        return Util.ConvertPacked4(this.data, 24);
    }

    public int smf7fl1() {
        return Util.ConvertUnsignedBinary1(this.data, 28);
    }

    public boolean smf7nrf() {
        return Util.ConvertFlag(this.data, this.smf7fl1(), 128);
    }

    public boolean smf7lsd() {
        return Util.ConvertFlag(this.data, this.smf7fl1(), 64);
    }

    public boolean smf7drp() {
        return Util.ConvertFlag(this.data, this.smf7fl1(), 32);
    }

    public int smf7rsv1() {
        return Util.ConvertUnsignedBinary2(this.data, 29);
    }

    public int smf7dtyp() {
        return Util.ConvertUnsignedBinary1(this.data, 31);
    }

    public long smf7nrox() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public String smf7lsn() {
        return Util.ConvertEbcdic(this.data, 36, 26);
    }

    public long smf7tbls() {
        return Util.ConvertUnsignedBinary8(this.data, 62);
    }

    public BigInteger smf7tblsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 62);
    }

    public int smf7dtypx() {
        return Util.ConvertUnsignedBinary2(this.data, 70);
    }

    static enum Field {
        smf7len(0, 2),
        smf7seg(2, 2),
        smf7flg(4, 1),
        smf7rty(5, 1),
        smf7tme(6, 4),
        smf7dte(10, 4),
        smf7sid(14, 4),
        smf7nro(18, 2),
        smf7stm(20, 4),
        smf7std(24, 4),
        smf7fl1(28, 1),
        smf7rsv1(29, 2),
        smf7dtyp(31, 1),
        smf7nrox(32, 4),
        smf7lsn(36, 26),
        smf7tbls(62, 8),
        smf7dtypx(70, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

