/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf70;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMF70RRF = 128;
    public static final int SMF70SUT = 64;
    public static final int SMF70V4 = 16;
    public static final int SMF70ESA = 8;
    public static final int SMF70VXA = 4;
    public static final int SMF70OS = 2;
    public static final int SMF70BFY = 1;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Header(byte[] Data2) {
        super(Data2);
    }

    public int smf70len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf70seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf70flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf70rrf() {
        return Util.ConvertFlag(this.data, this.smf70flg(), 128);
    }

    public boolean smf70sut() {
        return Util.ConvertFlag(this.data, this.smf70flg(), 64);
    }

    public boolean smf70v4() {
        return Util.ConvertFlag(this.data, this.smf70flg(), 16);
    }

    public boolean smf70esa() {
        return Util.ConvertFlag(this.data, this.smf70flg(), 8);
    }

    public boolean smf70vxa() {
        return Util.ConvertFlag(this.data, this.smf70flg(), 4);
    }

    public boolean smf70os() {
        return Util.ConvertFlag(this.data, this.smf70flg(), 2);
    }

    public boolean smf70bfy() {
        return Util.ConvertFlag(this.data, this.smf70flg(), 1);
    }

    public int smf70rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf70tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf70tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf70dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf70dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf70sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf70ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf70sty() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf70trn() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf70prs() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf70prl() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf70prn() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf70ccs() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf70ccl() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf70ccn() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf70cps() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf70cpl() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf70cpn() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf70ass() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf70asl() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf70asn() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf70bcs() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int smf70bcl() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf70bcn() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public int smf70bvs() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf70bvl() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf70bvn() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public int smf70cns() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertSignedBinary4(this.data, 76);
    }

    public int smf70cnl() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 80);
    }

    public int smf70cnn() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 82);
    }

    public int smf70cos() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertSignedBinary4(this.data, 84);
    }

    public int smf70col() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 88);
    }

    public int smf70con() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 90);
    }

    public int smf70tns() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertSignedBinary4(this.data, 92);
    }

    public int smf70tnl() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 96);
    }

    public int smf70tnn() {
        if (this.smf70sty() != 1) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 98);
    }

    public int smf7023s() {
        if (this.smf70sty() != 2) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 2)");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf7023l() {
        if (this.smf70sty() != 2) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 2)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf7023n() {
        if (this.smf70sty() != 2) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 2)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf7024s() {
        if (this.smf70sty() != 2) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 2)");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf7024l() {
        if (this.smf70sty() != 2) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 2)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf7024n() {
        if (this.smf70sty() != 2) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 2)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf702cs() {
        if (this.smf70sty() != 2) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 2)");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf702cl() {
        if (this.smf70sty() != 2) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 2)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf702cn() {
        if (this.smf70sty() != 2) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 2)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf7025s() {
        if (this.smf70sty() != 2) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 2)");
        }
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int smf7025l() {
        if (this.smf70sty() != 2) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 2)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf7025n() {
        if (this.smf70sty() != 2) {
            throw new NotAvailableException("This method is only supported when (smf70sty() == 2)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf70len(0, 2),
        smf70seg(2, 2),
        smf70flg(4, 1),
        smf70rty(5, 1),
        smf70tme(6, 4),
        smf70dte(10, 4),
        smf70sid(14, 4),
        smf70ssi(18, 4),
        smf70sty(22, 2),
        smf70trn(24, 2),
        smf70prs(28, 4),
        smf70prl(32, 2),
        smf70prn(34, 2),
        smf70ccs(36, 4),
        smf70ccl(40, 2),
        smf70ccn(42, 2),
        smf70cps(44, 4),
        smf70cpl(48, 2),
        smf70cpn(50, 2),
        smf70ass(52, 4),
        smf70asl(56, 2),
        smf70asn(58, 2),
        smf70bcs(60, 4),
        smf70bcl(64, 2),
        smf70bcn(66, 2),
        smf70bvs(68, 4),
        smf70bvl(72, 2),
        smf70bvn(74, 2),
        smf70cns(76, 4),
        smf70cnl(80, 2),
        smf70cnn(82, 2),
        smf70cos(84, 4),
        smf70col(88, 2),
        smf70con(90, 2),
        smf70tns(92, 4),
        smf70tnl(96, 2),
        smf70tnn(98, 2),
        smf7023s(36, 4),
        smf7023l(40, 2),
        smf7023n(42, 2),
        smf7024s(44, 4),
        smf7024l(48, 2),
        smf7024n(50, 2),
        smf702cs(52, 4),
        smf702cl(56, 2),
        smf702cn(58, 2),
        smf7025s(60, 4),
        smf7025l(64, 2),
        smf7025n(66, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

