/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf70;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf70.ReassemblyArea;
import com.blackhillsoftware.smf.values.BoostClass;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class ProductSection
extends SmfData {
    private ReassemblyArea m_reassemblyArea = null;
    public static final int SMF70CNV = 128;
    public static final int SMF70ISS = 64;
    public static final int SMF70M3R = 32;
    public static final int SMF70ISM = 16;
    public static final int SMF70RCL = 8;
    public static final int SMF70RCH = 4;
    public static final int SMF70AltVM = 2;
    public static final int SMF70IIP = 64;
    public static final int SMF70EED = 32;
    public static final int SMF70BOO = 7;
    public static final int SMF70QES = 128;
    public static final int SMF70CNE = 64;
    public static final int SMF70DRC = 32;
    public static final int SMF70EME = 16;
    public static final int SMF70PRI = 8;
    public static final int SMF70PRP = 4;
    public static final int SMF70PED = 2;
    public static final int SMF70PE2 = 1;

    private ProductSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ReassemblyArea reassemblyArea() {
        if (this.m_reassemblyArea == null && this.smf70ran() == 1) {
            this.m_reassemblyArea = ReassemblyArea.create(this.data, this.smf70rao(), this.smf70ral());
        }
        return this.m_reassemblyArea;
    }

    public int smf70mfv() {
        return Util.ConvertPacked2(this.data, 0);
    }

    public String smf70prd() {
        return Util.ConvertEbcdic(this.data, 2, 8);
    }

    public LocalTime smf70ist() {
        return Util.Packed_HHMMSS(this.data, 10);
    }

    public int smf70istRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public LocalDate smf70dat() {
        return Util.SMFDate(this.data, 14);
    }

    public int smf70datRawValue() {
        return Util.ConvertPacked4(this.data, 14);
    }

    public Duration smf70int() {
        return Util.Packed_MMSSTTT(this.data, 18);
    }

    public double smf70intSeconds() {
        return Util.ToSeconds(this.smf70int());
    }

    public int smf70intRawValue() {
        return Util.ConvertPacked4(this.data, 18);
    }

    public int smf70mfl() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long smf70sam() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int smf70rv2() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf70fla() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public boolean smf70cnv() {
        return Util.ConvertFlag(this.data, this.smf70fla(), 128, Field.smf70fla.length, 0);
    }

    public boolean smf70iss() {
        return Util.ConvertFlag(this.data, this.smf70fla(), 64, Field.smf70fla.length, 0);
    }

    public boolean smf70m3r() {
        return Util.ConvertFlag(this.data, this.smf70fla(), 32, Field.smf70fla.length, 0);
    }

    public boolean smf70ism() {
        return Util.ConvertFlag(this.data, this.smf70fla(), 16, Field.smf70fla.length, 0);
    }

    public boolean smf70rcl() {
        return Util.ConvertFlag(this.data, this.smf70fla(), 8, Field.smf70fla.length, 0);
    }

    public boolean smf70rch() {
        return Util.ConvertFlag(this.data, this.smf70fla(), 4, Field.smf70fla.length, 0);
    }

    public boolean smf70altVm() {
        return Util.ConvertFlag(this.data, this.smf70fla(), 2, Field.smf70fla.length, 0);
    }

    public boolean smf70iip() {
        return Util.ConvertFlag(this.data, this.smf70fla(), 64, Field.smf70fla.length, 1);
    }

    public boolean smf70eed() {
        return Util.ConvertFlag(this.data, this.smf70fla(), 32, Field.smf70fla.length, 1);
    }

    public BoostClass boostClass() {
        if (this.smf70iip() || this.smf70eed()) {
            return BoostClass.from(this.smf70fla() & 7);
        }
        return null;
    }

    public String smf70rls() {
        return Util.ConvertEbcdic(this.data, 32, 4);
    }

    public Duration smf70cyc() {
        return Util.Packed_MMSSTTT(this.data, 36);
    }

    public double smf70cycSeconds() {
        return Util.ToSeconds(this.smf70cyc());
    }

    public int smf70cycRawValue() {
        return Util.ConvertPacked4(this.data, 36);
    }

    public String smf70mvs() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public int smf70iml() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public int smf70prf() {
        return Util.ConvertUnsignedBinary1(this.data, 49);
    }

    public boolean smf70qes() {
        return Util.ConvertFlag(this.data, this.smf70prf(), 128);
    }

    public boolean smf70cne() {
        return Util.ConvertFlag(this.data, this.smf70prf(), 64);
    }

    public boolean smf70drc() {
        return Util.ConvertFlag(this.data, this.smf70prf(), 32);
    }

    public boolean smf70eme() {
        return Util.ConvertFlag(this.data, this.smf70prf(), 16);
    }

    public boolean smf70pri() {
        return Util.ConvertFlag(this.data, this.smf70prf(), 8);
    }

    public boolean smf70prp() {
        return Util.ConvertFlag(this.data, this.smf70prf(), 4);
    }

    public boolean smf70ped() {
        return Util.ConvertFlag(this.data, this.smf70prf(), 2);
    }

    public boolean smf70pe2() {
        return Util.ConvertFlag(this.data, this.smf70prf(), 1);
    }

    public int smf70ptn() {
        return Util.ConvertUnsignedBinary1(this.data, 50);
    }

    public int smf70srl() {
        return Util.ConvertUnsignedBinary1(this.data, 51);
    }

    public ZonedDateTime smf70iet() {
        return Util.Binary8xStckTime(this.data, 52);
    }

    public BigInteger smf70ietRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public ZoneOffset smf70lgo() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 60);
    }

    public long smf70lgoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 60);
    }

    public int smf70rao() {
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf70ral() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf70ran() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public Duration smf70oil() {
        return Util.Binary2Seconds(this.data, 76);
    }

    public double smf70oilSeconds() {
        return Util.ToSeconds(this.smf70oil());
    }

    public int smf70oilRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public Duration smf70syn() {
        return Util.Binary2Seconds(this.data, 78);
    }

    public double smf70synSeconds() {
        return Util.ToSeconds(this.smf70syn());
    }

    public int smf70synRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public ZonedDateTime smf70gie() {
        return Util.Binary8xStckTime(this.data, 80);
    }

    public BigInteger smf70gieRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public String smf70xnm() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public String smf70snm() {
        return Util.ConvertEbcdic(this.data, 96, 8);
    }

    public static ProductSection create(byte[] Data2, int offset, int length) {
        return new ProductSection(Data2, offset, length);
    }

    static enum Field {
        smf70mfv(0, 2),
        smf70prd(2, 8),
        smf70ist(10, 4),
        smf70dat(14, 4),
        smf70int(18, 4),
        smf70mfl(22, 2),
        smf70sam(24, 4),
        smf70rv2(28, 2),
        smf70fla(30, 2),
        smf70rls(32, 4),
        smf70cyc(36, 4),
        smf70mvs(40, 8),
        smf70iml(48, 1),
        smf70prf(49, 1),
        smf70ptn(50, 1),
        smf70srl(51, 1),
        smf70iet(52, 8),
        smf70lgo(60, 8),
        smf70rao(68, 4),
        smf70ral(72, 2),
        smf70ran(74, 2),
        smf70oil(76, 2),
        smf70syn(78, 2),
        smf70gie(80, 8),
        smf70xnm(88, 8),
        smf70snm(96, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

