/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf74.ReassemblyArea;
import com.blackhillsoftware.smf.values.BoostClass;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class ProductSection
extends SmfData {
    private ReassemblyArea m_reassemblyArea = null;
    public static final int SMF74CNV = 128;
    public static final int SMF74ISS = 64;
    public static final int SMF74M3R = 32;
    public static final int SMF74ISM = 16;
    public static final int SMF74RCL = 8;
    public static final int SMF74RCH = 4;
    public static final int SMF74AltVM = 2;
    public static final int SMF74IIP = 64;
    public static final int SMF74EED = 32;
    public static final int SMF74BOO = 7;
    public static final int SMF74QES = 128;
    public static final int SMF74CNE = 64;
    public static final int SMF74DRC = 32;
    public static final int SMF74EME = 16;
    public static final int SMF74PRI = 8;
    public static final int SMF74PRP = 4;
    public static final int SMF74PED = 2;
    public static final int SMF74PE2 = 1;

    private ProductSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ReassemblyArea reassemblyArea() {
        if (this.m_reassemblyArea == null && this.smf74ran() == 1) {
            this.m_reassemblyArea = ReassemblyArea.create(this.data, this.smf74rao(), this.smf74ral());
        }
        return this.m_reassemblyArea;
    }

    public int smf74mfv() {
        return Util.ConvertPacked2(this.data, 0);
    }

    public String smf74prd() {
        return Util.ConvertEbcdic(this.data, 2, 8);
    }

    public LocalTime smf74ist() {
        return Util.Packed_HHMMSS(this.data, 10);
    }

    public int smf74istRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public LocalDate smf74dat() {
        return Util.SMFDate(this.data, 14);
    }

    public int smf74datRawValue() {
        return Util.ConvertPacked4(this.data, 14);
    }

    public Duration smf74int() {
        return Util.Packed_MMSSTTT(this.data, 18);
    }

    public double smf74intSeconds() {
        return Util.ToSeconds(this.smf74int());
    }

    public int smf74intRawValue() {
        return Util.ConvertPacked4(this.data, 18);
    }

    public int smf74mfl() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long smf74sam() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int smf74rv2() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf74fla() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public boolean smf74cnv() {
        return Util.ConvertFlag(this.data, this.smf74fla(), 128, Field.smf74fla.length, 0);
    }

    public boolean smf74iss() {
        return Util.ConvertFlag(this.data, this.smf74fla(), 64, Field.smf74fla.length, 0);
    }

    public boolean smf74m3r() {
        return Util.ConvertFlag(this.data, this.smf74fla(), 32, Field.smf74fla.length, 0);
    }

    public boolean smf74ism() {
        return Util.ConvertFlag(this.data, this.smf74fla(), 16, Field.smf74fla.length, 0);
    }

    public boolean smf74rcl() {
        return Util.ConvertFlag(this.data, this.smf74fla(), 8, Field.smf74fla.length, 0);
    }

    public boolean smf74rch() {
        return Util.ConvertFlag(this.data, this.smf74fla(), 4, Field.smf74fla.length, 0);
    }

    public boolean smf74altVm() {
        return Util.ConvertFlag(this.data, this.smf74fla(), 2, Field.smf74fla.length, 0);
    }

    public boolean smf74iip() {
        return Util.ConvertFlag(this.data, this.smf74fla(), 64, Field.smf74fla.length, 1);
    }

    public boolean smf74eed() {
        return Util.ConvertFlag(this.data, this.smf74fla(), 32, Field.smf74fla.length, 1);
    }

    public BoostClass boostClass() {
        if (this.smf74iip() || this.smf74eed()) {
            return BoostClass.from(this.smf74fla() & 7);
        }
        return null;
    }

    public String smf74rls() {
        return Util.ConvertEbcdic(this.data, 32, 4);
    }

    public Duration smf74cyc() {
        return Util.Packed_MMSSTTT(this.data, 36);
    }

    public double smf74cycSeconds() {
        return Util.ToSeconds(this.smf74cyc());
    }

    public int smf74cycRawValue() {
        return Util.ConvertPacked4(this.data, 36);
    }

    public String smf74mvs() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public int smf74iml() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public int smf74prf() {
        return Util.ConvertUnsignedBinary1(this.data, 49);
    }

    public boolean smf74qes() {
        return Util.ConvertFlag(this.data, this.smf74prf(), 128);
    }

    public boolean smf74cne() {
        return Util.ConvertFlag(this.data, this.smf74prf(), 64);
    }

    public boolean smf74drc() {
        return Util.ConvertFlag(this.data, this.smf74prf(), 32);
    }

    public boolean smf74eme() {
        return Util.ConvertFlag(this.data, this.smf74prf(), 16);
    }

    public boolean smf74pri() {
        return Util.ConvertFlag(this.data, this.smf74prf(), 8);
    }

    public boolean smf74prp() {
        return Util.ConvertFlag(this.data, this.smf74prf(), 4);
    }

    public boolean smf74ped() {
        return Util.ConvertFlag(this.data, this.smf74prf(), 2);
    }

    public boolean smf74pe2() {
        return Util.ConvertFlag(this.data, this.smf74prf(), 1);
    }

    public int smf74ptn() {
        return Util.ConvertUnsignedBinary1(this.data, 50);
    }

    public int smf74srl() {
        return Util.ConvertUnsignedBinary1(this.data, 51);
    }

    public ZonedDateTime smf74iet() {
        return Util.Binary8xStckTime(this.data, 52);
    }

    public BigInteger smf74ietRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public ZoneOffset smf74lgo() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 60);
    }

    public long smf74lgoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 60);
    }

    public int smf74rao() {
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf74ral() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf74ran() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public Duration smf74oil() {
        return Util.Binary2Seconds(this.data, 76);
    }

    public double smf74oilSeconds() {
        return Util.ToSeconds(this.smf74oil());
    }

    public int smf74oilRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public Duration smf74syn() {
        return Util.Binary2Seconds(this.data, 78);
    }

    public double smf74synSeconds() {
        return Util.ToSeconds(this.smf74syn());
    }

    public int smf74synRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public ZonedDateTime smf74gie() {
        return Util.Binary8xStckTime(this.data, 80);
    }

    public BigInteger smf74gieRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public String smf74xnm() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public String smf74snm() {
        return Util.ConvertEbcdic(this.data, 96, 8);
    }

    public static ProductSection create(byte[] Data2, int offset, int length) {
        return new ProductSection(Data2, offset, length);
    }

    static enum Field {
        smf74mfv(0, 2),
        smf74prd(2, 8),
        smf74ist(10, 4),
        smf74dat(14, 4),
        smf74int(18, 4),
        smf74mfl(22, 2),
        smf74sam(24, 4),
        smf74rv2(28, 2),
        smf74fla(30, 2),
        smf74rls(32, 4),
        smf74cyc(36, 4),
        smf74mvs(40, 8),
        smf74iml(48, 1),
        smf74prf(49, 1),
        smf74ptn(50, 1),
        smf74srl(51, 1),
        smf74iet(52, 8),
        smf74lgo(60, 8),
        smf74rao(68, 4),
        smf74ral(72, 2),
        smf74ran(74, 2),
        smf74oil(76, 2),
        smf74syn(78, 2),
        smf74gie(80, 8),
        smf74xnm(88, 8),
        smf74snm(96, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

