/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype1;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class DeviceControlDataSection
extends SmfData {
    public static final int MAGNETIC_TAPE = 128;
    public static final int COMMUNICATION = 64;
    public static final int DASD = 32;
    public static final int GRAPHICS = 16;
    public static final int UNIT_RECORD = 8;
    public static final int CHARACTER_READER = 4;
    public static final int SMF74NRF = 128;
    public static final int SMF74SGF = 64;
    public static final int SMF74429 = 128;
    public static final int SMF74SME = 64;
    public static final int SMF74438 = 32;
    public static final int SMF74ECM = 128;
    public static final int SMF74STS = 64;
    public static final int SMF74FCM = 32;
    public static final int SMF74FID = 16;
    public static final int SMF74MSM = 128;
    public static final int SMF74DCA = 128;
    public static final int SMF74IAC = 64;
    public static final int SMF74IOD = 32;
    public static final int SMF74ICV = 16;

    private DeviceControlDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf74nxt() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf74tot() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf74gen() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public int smf74sub() {
        return Util.ConvertUnsignedBinary2(this.data, 6);
    }

    public boolean deviceClassMagneticTape() {
        return Util.ConvertFlag(this.data, this.smf74sub(), 128);
    }

    public boolean deviceClassCommunication() {
        return Util.ConvertFlag(this.data, this.smf74sub(), 64);
    }

    public boolean deviceClassDasd() {
        return Util.ConvertFlag(this.data, this.smf74sub(), 32);
    }

    public boolean deviceClassGraphics() {
        return Util.ConvertFlag(this.data, this.smf74sub(), 16);
    }

    public boolean deviceClassUnitRecord() {
        return Util.ConvertFlag(this.data, this.smf74sub(), 8);
    }

    public boolean deviceClassCharacterReader() {
        return Util.ConvertFlag(this.data, this.smf74sub(), 4);
    }

    public int smf74dfl() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    public int smf74dcf() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public boolean smf74nrf() {
        return Util.ConvertFlag(this.data, this.smf74dcf(), 128);
    }

    public boolean smf74sgf() {
        return Util.ConvertFlag(this.data, this.smf74dcf(), 64);
    }

    public int smf74dms() {
        return Util.ConvertUnsignedBinary1(this.data, 9);
    }

    public boolean smf74429() {
        return Util.ConvertFlag(this.data, this.smf74dms(), 128);
    }

    public boolean smf74sme() {
        return Util.ConvertFlag(this.data, this.smf74dms(), 64);
    }

    public boolean smf74438() {
        return Util.ConvertFlag(this.data, this.smf74dms(), 32);
    }

    public int smf74enf() {
        return Util.ConvertUnsignedBinary1(this.data, 10);
    }

    public boolean smf74ecm() {
        return Util.ConvertFlag(this.data, this.smf74enf(), 128);
    }

    public boolean smf74sts() {
        return Util.ConvertFlag(this.data, this.smf74enf(), 64);
    }

    public boolean smf74fcm() {
        return Util.ConvertFlag(this.data, this.smf74enf(), 32);
    }

    public boolean smf74fid() {
        return Util.ConvertFlag(this.data, this.smf74enf(), 16);
    }

    public int smf74smf() {
        return Util.ConvertUnsignedBinary1(this.data, 11);
    }

    public boolean smf74msm() {
        return Util.ConvertFlag(this.data, this.smf74smf(), 128);
    }

    public int smf74s15() {
        return Util.ConvertSignedBinary4(this.data, 12);
    }

    public int smf74src() {
        return Util.ConvertSignedBinary4(this.data, 16);
    }

    public int smf74srs() {
        return Util.ConvertSignedBinary4(this.data, 20);
    }

    public int smf74tsr() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf74cfl() {
        return Util.ConvertUnsignedBinary1(this.data, 26);
    }

    public boolean smf74dca() {
        return Util.ConvertFlag(this.data, this.smf74cfl(), 128);
    }

    public boolean smf74iac() {
        return Util.ConvertFlag(this.data, this.smf74cfl(), 64);
    }

    public boolean smf74iod() {
        return Util.ConvertFlag(this.data, this.smf74cfl(), 32);
    }

    public boolean smf74icv() {
        return Util.ConvertFlag(this.data, this.smf74cfl(), 16);
    }

    public int smf74lsn() {
        return Util.ConvertUnsignedBinary1(this.data, 27);
    }

    public String smf74tnm() {
        return Util.ConvertEbcdic(this.data, 30, 44);
    }

    public String smf74tsf() {
        return Util.ConvertEbcdic(this.data, 74, 2);
    }

    public String smf74tok() {
        return Util.ConvertEbcdic(this.data, 78, 16);
    }

    public LocalDate smf74tdt() {
        return Util.EBCDIC8mm_dd_yy(this.data, 78);
    }

    public String smf74tdtRawValue() {
        return Util.ConvertEbcdic(this.data, 78, 8);
    }

    public LocalTime smf74ttm() {
        return Util.EBCDIC8hh_mm_ss(this.data, 86);
    }

    public String smf74ttmRawValue() {
        return Util.ConvertEbcdic(this.data, 86, 8);
    }

    public long smf74mct() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public LocalDate smf74tdy() {
        return Util.EBCDIC10mm_dd_yyyy(this.data, 100);
    }

    public String smf74tdyRawValue() {
        return Util.ConvertEbcdic(this.data, 100, 10);
    }

    public static DeviceControlDataSection create(byte[] Data2, int offset, int length) {
        return new DeviceControlDataSection(Data2, offset, length);
    }

    static enum Field {
        smf74nxt(0, 2),
        smf74tot(2, 2),
        smf74gen(4, 2),
        smf74sub(6, 2),
        smf74dfl(8, 2),
        smf74dcf(8, 1),
        smf74dms(9, 1),
        smf74enf(10, 1),
        smf74smf(11, 1),
        smf74s15(12, 4),
        smf74src(16, 4),
        smf74srs(20, 4),
        smf74tsr(24, 2),
        smf74cfl(26, 1),
        smf74lsn(27, 1),
        smf74tnm(30, 44),
        smf74tsf(74, 2),
        smf74tok(78, 16),
        smf74tdt(78, 8),
        smf74ttm(86, 8),
        smf74mct(96, 4),
        smf74tdy(100, 10);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

