/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype1;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class DeviceDataSection
extends SmfData {
    public static final int SMF74QUL = 128;
    public static final int SMF74LCD = 64;
    public static final int SMF74CMB = 32;
    public static final int SMF74DEL = 16;
    public static final int SMF74PAR = 8;
    public static final int SMF74MXB = 4;
    public static final int SMF74VAC = 2;
    public static final int SMF74STA = 1;
    public static final int SMF74RCF = 224;
    public static final int SMF74RNR = 128;
    public static final int SMF74RSG = 64;
    public static final int SMF74RCS = 32;
    public static final int SMF74TCF = 28;
    public static final int SMF74MTS = 16;
    public static final int SMF74MTE = 8;
    public static final int SMF74CTC = 3;
    public static final int SMF74CLW = 2;
    public static final int SMF74DYC = 128;
    public static final int SMF74DDT = 64;
    public static final int SMF74PAV = 32;
    public static final int SMF74NXC = 16;
    public static final int SMF74NTF = 8;
    public static final int SMF74CNI = 4;
    public static final int SMF74HPV = 2;
    public static final int SMF74CFC = 1;
    public static final int SMF74HWR = 128;
    public static final int SMF74XPV = 64;
    public static final int SMF74SIR = 32;
    public static final int SMF74SIW = 16;
    public static final int SMF74SRD = 128;
    public static final int SMF74SND = 64;
    public static final int SMF74SCN = 32;
    public static final int SMF74SHV = 16;
    public static final int SMF74SHR = 8;

    private DeviceDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf74num() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf74lcu() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf74rv3() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf74cnf() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public boolean smf74qul() {
        return Util.ConvertFlag(this.data, this.smf74cnf(), 128);
    }

    public boolean smf74lcd() {
        return Util.ConvertFlag(this.data, this.smf74cnf(), 64);
    }

    public boolean smf74cmb() {
        return Util.ConvertFlag(this.data, this.smf74cnf(), 32);
    }

    public boolean smf74del() {
        return Util.ConvertFlag(this.data, this.smf74cnf(), 16);
    }

    public boolean smf74par() {
        return Util.ConvertFlag(this.data, this.smf74cnf(), 8);
    }

    public boolean smf74mxb() {
        return Util.ConvertFlag(this.data, this.smf74cnf(), 4);
    }

    public boolean smf74vac() {
        return Util.ConvertFlag(this.data, this.smf74cnf(), 2);
    }

    public boolean smf74sta() {
        return Util.ConvertFlag(this.data, this.smf74cnf(), 1);
    }

    public String smf74ser() {
        return Util.ConvertEbcdic(this.data, 6, 6);
    }

    public long smf74typ() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf74nux() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smf74ssc() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smf74mec() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public Duration smf74cnn() {
        return Util.Binary4x128US(this.data, 28);
    }

    public double smf74cnnSeconds() {
        return Util.ToSeconds(this.smf74cnn());
    }

    public long smf74cnnRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public Duration smf74pen() {
        return Util.Binary4x128US(this.data, 32);
    }

    public double smf74penSeconds() {
        return Util.ToSeconds(this.smf74pen());
    }

    public long smf74penRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public Duration smf74atv() {
        return Util.Binary4x128US(this.data, 36);
    }

    public double smf74atvSeconds() {
        return Util.ToSeconds(this.smf74atv());
    }

    public long smf74atvRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public Duration smf74dis() {
        return Util.Binary4x128US(this.data, 40);
    }

    public double smf74disSeconds() {
        return Util.ToSeconds(this.smf74dis());
    }

    public long smf74disRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long smf74que() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long smf74utl() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long smf74rsv() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long smf74dso() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long smf74alc() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long smf74mtp() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long smf74nrd() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public int smf74cof() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf74ict() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public Duration smf74dvb() {
        return Util.Binary4x128US(this.data, 76);
    }

    public double smf74dvbSeconds() {
        return Util.ToSeconds(this.smf74dvb());
    }

    public long smf74dvbRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long smf74cub() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public int smf74clf() {
        return Util.ConvertUnsignedBinary1(this.data, 84);
    }

    public boolean smf74rnr() {
        return Util.ConvertFlag(this.data, this.smf74clf(), 128);
    }

    public boolean smf74rsg() {
        return Util.ConvertFlag(this.data, this.smf74clf(), 64);
    }

    public boolean smf74rcs() {
        return Util.ConvertFlag(this.data, this.smf74clf(), 32);
    }

    public boolean smf74mts() {
        return Util.ConvertFlag(this.data, this.smf74clf(), 16);
    }

    public boolean smf74mte() {
        return Util.ConvertFlag(this.data, this.smf74clf(), 8);
    }

    public boolean smf74clw() {
        return Util.ConvertFlag(this.data, this.smf74clf(), 2);
    }

    public String smf74sgn() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public long smf74nda() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public String smf74dev() {
        return Util.ConvertEbcdic(this.data, 100, 8);
    }

    public String smf74cu() {
        return Util.ConvertEbcdic(this.data, 108, 8);
    }

    public long smf74dpb() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public int smf74cnx() {
        return Util.ConvertUnsignedBinary1(this.data, 120);
    }

    public boolean smf74dyc() {
        return Util.ConvertFlag(this.data, this.smf74cnx(), 128);
    }

    public boolean smf74ddt() {
        return Util.ConvertFlag(this.data, this.smf74cnx(), 64);
    }

    public boolean smf74pav() {
        return Util.ConvertFlag(this.data, this.smf74cnx(), 32);
    }

    public boolean smf74nxc() {
        return Util.ConvertFlag(this.data, this.smf74cnx(), 16);
    }

    public boolean smf74ntf() {
        return Util.ConvertFlag(this.data, this.smf74cnx(), 8);
    }

    public boolean smf74cni() {
        return Util.ConvertFlag(this.data, this.smf74cnx(), 4);
    }

    public boolean smf74hpv() {
        return Util.ConvertFlag(this.data, this.smf74cnx(), 2);
    }

    public boolean smf74cfc() {
        return Util.ConvertFlag(this.data, this.smf74cnx(), 1);
    }

    public int smf74cn2() {
        return Util.ConvertUnsignedBinary1(this.data, 121);
    }

    public boolean smf74hwr() {
        return Util.ConvertFlag(this.data, this.smf74cn2(), 128);
    }

    public boolean smf74xpv() {
        return Util.ConvertFlag(this.data, this.smf74cn2(), 64);
    }

    public boolean smf74sir() {
        return Util.ConvertFlag(this.data, this.smf74cn2(), 32);
    }

    public boolean smf74siw() {
        return Util.ConvertFlag(this.data, this.smf74cn2(), 16);
    }

    public int smf74mtc() {
        return Util.ConvertUnsignedBinary2(this.data, 122);
    }

    public int smf74dts() {
        return Util.ConvertUnsignedBinary1(this.data, 124);
    }

    public boolean smf74srd() {
        return Util.ConvertFlag(this.data, this.smf74dts(), 128);
    }

    public boolean smf74snd() {
        return Util.ConvertFlag(this.data, this.smf74dts(), 64);
    }

    public boolean smf74scn() {
        return Util.ConvertFlag(this.data, this.smf74dts(), 32);
    }

    public boolean smf74shv() {
        return Util.ConvertFlag(this.data, this.smf74dts(), 16);
    }

    public boolean smf74shr() {
        return Util.ConvertFlag(this.data, this.smf74dts(), 8);
    }

    public String smf74ndn() {
        return Util.ConvertEbcdic(this.data, 125, 4);
    }

    public String smf74nbl() {
        return Util.ConvertEbcdic(this.data, 129, 24);
    }

    public int smf74hpc() {
        return Util.ConvertUnsignedBinary1(this.data, 153);
    }

    public int smf74nss() {
        return Util.ConvertUnsignedBinary2(this.data, 154);
    }

    public long smf74psm() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public long smf74pct() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public Duration smf74cmr() {
        return Util.Binary4x128US(this.data, 164);
    }

    public double smf74cmrSeconds() {
        return Util.ToSeconds(this.smf74cmr());
    }

    public long smf74cmrRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public long smf74cap() {
        return Util.ConvertUnsignedBinary4(this.data, 168);
    }

    public Duration smf74idt() {
        return Util.Binary4x128US(this.data, 172);
    }

    public double smf74idtSeconds() {
        return Util.ToSeconds(this.smf74idt());
    }

    public long smf74idtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 172);
    }

    public Duration smf74cuq() {
        return Util.Binary4x128US(this.data, 176);
    }

    public double smf74cuqSeconds() {
        return Util.ToSeconds(this.smf74cuq());
    }

    public long smf74cuqRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 176);
    }

    public int smf74scs() {
        return Util.ConvertUnsignedBinary1(this.data, 181);
    }

    public int smf74nm2() {
        return Util.ConvertUnsignedBinary2(this.data, 182);
    }

    public long smf74atd() {
        return Util.ConvertUnsignedBinary4(this.data, 184);
    }

    public int smf74agc() {
        return Util.ConvertUnsignedBinary1(this.data, 191);
    }

    public long smf74ags() {
        return Util.ConvertUnsignedBinary4(this.data, 192);
    }

    public double smf74sbr() {
        return Util.ConvertLongFPHex(this.data, 200);
    }

    public double smf74sbw() {
        return Util.ConvertLongFPHex(this.data, 208);
    }

    public double smf74sqr() {
        return Util.ConvertLongFPHex(this.data, 216);
    }

    public double smf74sqw() {
        return Util.ConvertLongFPHex(this.data, 224);
    }

    public Duration smf74spr() {
        return Util.LongFpHex_0_5_US(this.data, 232);
    }

    public double smf74sprSeconds() {
        return Util.ToSeconds(this.smf74spr());
    }

    public double smf74sprRawValue() {
        return Util.ConvertLongFPHex(this.data, 232);
    }

    public Duration smf74spw() {
        return Util.LongFpHex_0_5_US(this.data, 240);
    }

    public double smf74spwSeconds() {
        return Util.ToSeconds(this.smf74spw());
    }

    public double smf74spwRawValue() {
        return Util.ConvertLongFPHex(this.data, 240);
    }

    public Duration smf74sftr() {
        return Util.LongFpHex_0_5_US(this.data, 248);
    }

    public double smf74sftrSeconds() {
        return Util.ToSeconds(this.smf74sftr());
    }

    public double smf74sftrRawValue() {
        return Util.ConvertLongFPHex(this.data, 248);
    }

    public Duration smf74sftw() {
        return Util.LongFpHex_0_5_US(this.data, 256);
    }

    public double smf74sftwSeconds() {
        return Util.ToSeconds(this.smf74sftw());
    }

    public double smf74sftwRawValue() {
        return Util.ConvertLongFPHex(this.data, 256);
    }

    public double smf74slbr() {
        return Util.ConvertShortFPHex(this.data, 264);
    }

    public double smf74slbw() {
        return Util.ConvertShortFPHex(this.data, 268);
    }

    public double smf74scmr() {
        return Util.ConvertShortFPHex(this.data, 272);
    }

    public double smf74snis() {
        return Util.ConvertShortFPHex(this.data, 276);
    }

    public double smf74stor() {
        return Util.ConvertShortFPHex(this.data, 280);
    }

    public double smf74stow() {
        return Util.ConvertShortFPHex(this.data, 284);
    }

    public double smf74sor() {
        return Util.ConvertShortFPHex(this.data, 288);
    }

    public double smf74sow() {
        return Util.ConvertShortFPHex(this.data, 292);
    }

    public Duration smf74ios() {
        return Util.ShortFpHex_US(this.data, 296);
    }

    public double smf74iosSeconds() {
        return Util.ToSeconds(this.smf74ios());
    }

    public double smf74iosRawValue() {
        return Util.ConvertShortFPHex(this.data, 296);
    }

    public static DeviceDataSection create(byte[] Data2, int offset, int length) {
        return new DeviceDataSection(Data2, offset, length);
    }

    static enum Field {
        smf74num(0, 2),
        smf74lcu(2, 2),
        smf74rv3(4, 1),
        smf74cnf(5, 1),
        smf74ser(6, 6),
        smf74typ(12, 4),
        smf74nux(16, 4),
        smf74ssc(20, 4),
        smf74mec(24, 4),
        smf74cnn(28, 4),
        smf74pen(32, 4),
        smf74atv(36, 4),
        smf74dis(40, 4),
        smf74que(44, 4),
        smf74utl(48, 4),
        smf74rsv(52, 4),
        smf74dso(56, 4),
        smf74alc(60, 4),
        smf74mtp(64, 4),
        smf74nrd(68, 4),
        smf74cof(72, 2),
        smf74ict(74, 2),
        smf74dvb(76, 4),
        smf74cub(80, 4),
        smf74clf(84, 1),
        smf74sgn(88, 8),
        smf74nda(96, 4),
        smf74dev(100, 8),
        smf74cu(108, 8),
        smf74dpb(116, 4),
        smf74cnx(120, 1),
        smf74cn2(121, 1),
        smf74mtc(122, 2),
        smf74dts(124, 1),
        smf74ndn(125, 4),
        smf74nbl(129, 24),
        smf74hpc(153, 1),
        smf74nss(154, 2),
        smf74psm(156, 4),
        smf74pct(160, 4),
        smf74cmr(164, 4),
        smf74cap(168, 4),
        smf74idt(172, 4),
        smf74cuq(176, 4),
        smf74scs(181, 1),
        smf74nm2(182, 2),
        smf74atd(184, 4),
        smf74agc(191, 1),
        smf74ags(192, 4),
        smf74sbr(200, 8),
        smf74sbw(208, 8),
        smf74sqr(216, 8),
        smf74sqw(224, 8),
        smf74spr(232, 8),
        smf74spw(240, 8),
        smf74sftr(248, 8),
        smf74sftw(256, 8),
        smf74slbr(264, 4),
        smf74slbw(268, 4),
        smf74scmr(272, 4),
        smf74snis(276, 4),
        smf74stor(280, 4),
        smf74stow(284, 4),
        smf74sor(288, 4),
        smf74sow(292, 4),
        smf74ios(296, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

