/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype4;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CfRemoteFacilityDataSection
extends SmfData {
    public static final int R744RCEI = 128;
    public static final int R744RADI = 64;
    private List<String> m_r744rtap = null;
    int[] m_r744ridp = null;
    private List<String> m_r744rsap = null;
    int[] m_r744rsid = null;

    private CfRemoteFacilityDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public SmfData r744rnde() {
        if (this.data.length >= 32) {
            return new SmfData(this.data, 0, 32);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(0) + " Data length: " + Integer.toString(32));
    }

    public SmfData r744rsys() {
        if (this.data.length >= 40) {
            return new SmfData(this.data, 32, 8);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(32) + " Data length: " + Integer.toString(8));
    }

    public String r744rnam() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public int r744rpgs() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public int r744rflg() {
        return Util.ConvertUnsignedBinary1(this.data, 49);
    }

    public boolean r744rcei() {
        return Util.ConvertFlag(this.data, this.r744rflg(), 128);
    }

    public boolean r744radi() {
        return Util.ConvertFlag(this.data, this.r744rflg(), 64);
    }

    public long r744rres() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long r744rrcs() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long r744rhes() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long r744rrss() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long r744rrsa() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long r744rsst() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public double r744rsssSecondsSq() {
        return Util.Binary8USSquared(this.data, 76);
    }

    public BigInteger r744rsssRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 76);
    }

    public long r744rdsc() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public Duration r744rsdt() {
        return Util.Binary4US(this.data, 88);
    }

    public double r744rsdtSeconds() {
        return Util.ToSeconds(this.r744rsdt());
    }

    public long r744rsdtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public double r744rssdSecondsSq() {
        return Util.Binary8USSquared(this.data, 92);
    }

    public BigInteger r744rssdRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 92);
    }

    public long r744rsrs() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public List<String> r744rtap() {
        if (this.m_r744rtap != null) {
            return this.m_r744rtap;
        }
        ArrayList<String> result = new ArrayList<String>(8);
        for (int i = 0; i < 8; ++i) {
            result.add(Util.ConvertEbcdic(this.data, Field.r744rtap.offset + i * Field.r744rtap.length, Field.r744rtap.length));
        }
        this.m_r744rtap = Collections.unmodifiableList(result);
        return this.m_r744rtap;
    }

    public Duration r744rsse() {
        return Util.Binary8USSeconds(this.data, 144);
    }

    public double r744rsseSeconds() {
        return Util.ToSeconds(this.r744rsse());
    }

    public BigInteger r744rsseRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 144);
    }

    public int[] r744ridp() {
        if (this.m_r744ridp != null) {
            return this.m_r744ridp;
        }
        int[] result = new int[8];
        for (int i = 0; i < 8; ++i) {
            result[i] = Util.ConvertUnsignedBinary1(this.data, Field.r744ridp.offset + i * Field.r744ridp.length);
        }
        this.m_r744ridp = result;
        return result;
    }

    public int r744rcpi() {
        return Util.ConvertUnsignedBinary2(this.data, 160);
    }

    public int r744rcpn() {
        return Util.ConvertUnsignedBinary2(this.data, 162);
    }

    public int r744rsgs() {
        return Util.ConvertUnsignedBinary1(this.data, 164);
    }

    public List<String> r744rsap() {
        if (this.m_r744rsap != null) {
            return this.m_r744rsap;
        }
        ArrayList<String> result = new ArrayList<String>(8);
        for (int i = 0; i < 8; ++i) {
            result.add(Util.ConvertEbcdic(this.data, Field.r744rsap.offset + i * Field.r744rsap.length, Field.r744rsap.length));
        }
        this.m_r744rsap = Collections.unmodifiableList(result);
        return this.m_r744rsap;
    }

    public int[] r744rsid() {
        if (this.m_r744rsid != null) {
            return this.m_r744rsid;
        }
        int[] result = new int[8];
        for (int i = 0; i < 8; ++i) {
            result[i] = Util.ConvertUnsignedBinary1(this.data, Field.r744rsid.offset + i * Field.r744rsid.length);
        }
        this.m_r744rsid = result;
        return result;
    }

    public long r744rsc() {
        return Util.ConvertUnsignedBinary4(this.data, 216);
    }

    public long r744ramc() {
        return Util.ConvertUnsignedBinary4(this.data, 220);
    }

    public Duration r744ramst() {
        return Util.Binary8USSeconds(this.data, 224);
    }

    public double r744ramstSeconds() {
        return Util.ToSeconds(this.r744ramst());
    }

    public BigInteger r744ramstRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 224);
    }

    public double r744ramsqSecondsSq() {
        return Util.Binary8USSquared(this.data, 232);
    }

    public BigInteger r744ramsqRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 232);
    }

    public long r744rampb() {
        return Util.ConvertUnsignedBinary4(this.data, 240);
    }

    public long r744ramns() {
        return Util.ConvertUnsignedBinary4(this.data, 244);
    }

    public static CfRemoteFacilityDataSection create(byte[] Data2, int offset, int length) {
        return new CfRemoteFacilityDataSection(Data2, offset, length);
    }

    static enum Field {
        r744rnde(0, 32),
        r744rsys(32, 8),
        r744rnam(40, 8),
        r744rpgs(48, 1),
        r744rflg(49, 1),
        r744rres(52, 4),
        r744rrcs(56, 4),
        r744rhes(60, 4),
        r744rrss(64, 4),
        r744rrsa(68, 4),
        r744rsst(72, 4),
        r744rsss(76, 8),
        r744rdsc(84, 4),
        r744rsdt(88, 4),
        r744rssd(92, 8),
        r744rsrs(100, 4),
        r744rtap(104, 5),
        r744rsse(144, 8),
        r744ridp(152, 1),
        r744rcpi(160, 2),
        r744rcpn(162, 2),
        r744rsgs(164, 1),
        r744rsap(168, 5),
        r744rsid(208, 1),
        r744rsc(216, 4),
        r744ramc(220, 4),
        r744ramst(224, 8),
        r744ramsq(232, 8),
        r744rampb(240, 4),
        r744ramns(244, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

