/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype6;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class HfsFileSystemSection
extends SmfData {
    public static final int R746FNHS = 128;
    public static final int R746FMTC = 64;
    public static final int R746FFSM = 32;

    private HfsFileSystemSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String r746fsnm() {
        if (this.data.length >= 0 + this.r746fsnl()) {
            return Util.ConvertEbcdic(this.data, 0, this.r746fsnl());
        }
        return null;
    }

    public int r746fsnl() {
        return Util.ConvertUnsignedBinary1(this.data, 44);
    }

    public int r746fsfl() {
        return Util.ConvertUnsignedBinary1(this.data, 45);
    }

    public boolean r746fnhs() {
        return Util.ConvertFlag(this.data, this.r746fsfl(), 128);
    }

    public boolean r746fmtc() {
        return Util.ConvertFlag(this.data, this.r746fsfl(), 64);
    }

    public boolean r746ffsm() {
        return Util.ConvertFlag(this.data, this.r746fsfl(), 32);
    }

    public ZonedDateTime r746fctm() {
        return Util.Binary8xStckTime(this.data, 48);
    }

    public BigInteger r746fctmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public ZonedDateTime r746fmtm() {
        return Util.Binary8xStckTime(this.data, 56);
    }

    public BigInteger r746fmtmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public long r746fsf() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long r746fpf() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long r746fpd() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long r746fpc() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public double r746fsfi() {
        return Util.ConvertLongFPHex(this.data, 80);
    }

    public double r746frfi() {
        return Util.ConvertLongFPHex(this.data, 88);
    }

    public double r746fmc() {
        return Util.ConvertLongFPHex(this.data, 96);
    }

    public double r746fmnc() {
        return Util.ConvertLongFPHex(this.data, 104);
    }

    public double r746f1c() {
        return Util.ConvertLongFPHex(this.data, 112);
    }

    public double r746f1nc() {
        return Util.ConvertLongFPHex(this.data, 120);
    }

    public double r746fint() {
        return Util.ConvertLongFPHex(this.data, 128);
    }

    public double r746fis() {
        return Util.ConvertLongFPHex(this.data, 136);
    }

    public double r746fij() {
        return Util.ConvertLongFPHex(this.data, 144);
    }

    public double r746firh() {
        return Util.ConvertLongFPHex(this.data, 152);
    }

    public double r746firm() {
        return Util.ConvertLongFPHex(this.data, 160);
    }

    public double r746fiwh() {
        return Util.ConvertLongFPHex(this.data, 168);
    }

    public double r746fiwm() {
        return Util.ConvertLongFPHex(this.data, 176);
    }

    public long r746fsrc() {
        return Util.ConvertUnsignedBinary4(this.data, 184);
    }

    public long r746fsrs() {
        return Util.ConvertUnsignedBinary4(this.data, 188);
    }

    public static HfsFileSystemSection create(byte[] Data2, int offset, int length) {
        return new HfsFileSystemSection(Data2, offset, length);
    }

    static enum Field {
        r746fsnm(0, 0),
        r746fsnl(44, 1),
        r746fsfl(45, 1),
        r746fctm(48, 8),
        r746fmtm(56, 8),
        r746fsf(64, 4),
        r746fpf(68, 4),
        r746fpd(72, 4),
        r746fpc(76, 4),
        r746fsfi(80, 8),
        r746frfi(88, 8),
        r746fmc(96, 8),
        r746fmnc(104, 8),
        r746f1c(112, 8),
        r746f1nc(120, 8),
        r746fint(128, 8),
        r746fis(136, 8),
        r746fij(144, 8),
        r746firh(152, 8),
        r746firm(160, 8),
        r746fiwh(168, 8),
        r746fiwm(176, 8),
        r746fsrc(184, 4),
        r746fsrs(188, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

