/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype7;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class FcdPortDataSection
extends SmfData {
    public static final int R747PSCU = 128;
    public static final int R747PMCU = 64;
    public static final int R747PCHP = 32;
    public static final int R747PSW = 16;
    public static final int R747PTNU = 128;
    public static final int R747PINU = 64;
    public static final int R747POSY = 32;
    public static final int R747PINS = 16;
    public static final int R747PVAR = 8;
    public static final int R747PREM = 4;
    public static final int R747PACT = 2;
    public static final int R747PNMD = 1;
    public static final int R747PPIR = 128;
    public static final int R747PNTI = 64;
    public static final int R747PLF = 32;
    public static final int R747POFF = 16;
    public static final int R747PSCR = 8;

    private FcdPortDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int r747pnum() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public int r747padr() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public int r747ptfl() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean r747pscu() {
        return Util.ConvertFlag(this.data, this.r747ptfl(), 128);
    }

    public boolean r747pmcu() {
        return Util.ConvertFlag(this.data, this.r747ptfl(), 64);
    }

    public boolean r747pchp() {
        return Util.ConvertFlag(this.data, this.r747ptfl(), 32);
    }

    public boolean r747psw() {
        return Util.ConvertFlag(this.data, this.r747ptfl(), 16);
    }

    public int r747psfl() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public boolean r747ptnu() {
        return Util.ConvertFlag(this.data, this.r747psfl(), 128);
    }

    public boolean r747pinu() {
        return Util.ConvertFlag(this.data, this.r747psfl(), 64);
    }

    public boolean r747posy() {
        return Util.ConvertFlag(this.data, this.r747psfl(), 32);
    }

    public boolean r747pins() {
        return Util.ConvertFlag(this.data, this.r747psfl(), 16);
    }

    public boolean r747pvar() {
        return Util.ConvertFlag(this.data, this.r747psfl(), 8);
    }

    public boolean r747prem() {
        return Util.ConvertFlag(this.data, this.r747psfl(), 4);
    }

    public boolean r747pact() {
        return Util.ConvertFlag(this.data, this.r747psfl(), 2);
    }

    public boolean r747pnmd() {
        return Util.ConvertFlag(this.data, this.r747psfl(), 1);
    }

    public int r747pcu() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public int r747pcp() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public int r747pcun() {
        return Util.ConvertUnsignedBinary1(this.data, 6);
    }

    public int r747pnpc() {
        return Util.ConvertUnsignedBinary1(this.data, 7);
    }

    public int r747pxpc() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    public int r747ppfl() {
        return Util.ConvertUnsignedBinary1(this.data, 10);
    }

    public boolean r747ppir() {
        return Util.ConvertFlag(this.data, this.r747ppfl(), 128);
    }

    public boolean r747pnti() {
        return Util.ConvertFlag(this.data, this.r747ppfl(), 64);
    }

    public boolean r747plf() {
        return Util.ConvertFlag(this.data, this.r747ppfl(), 32);
    }

    public boolean r747poff() {
        return Util.ConvertFlag(this.data, this.r747ppfl(), 16);
    }

    public boolean r747pscr() {
        return Util.ConvertFlag(this.data, this.r747ppfl(), 8);
    }

    public Duration r747pfpt() {
        return Util.LongFpHex_2_5_US(this.data, 16);
    }

    public double r747pfptSeconds() {
        return Util.ToSeconds(this.r747pfpt());
    }

    public double r747pfptRawValue() {
        return Util.ConvertLongFPHex(this.data, 16);
    }

    public double r747pnwr() {
        return Util.ConvertLongFPHex(this.data, 24);
    }

    public double r747pnwt() {
        return Util.ConvertLongFPHex(this.data, 32);
    }

    public double r747pnfr() {
        return Util.ConvertLongFPHex(this.data, 40);
    }

    public double r747pnft() {
        return Util.ConvertLongFPHex(this.data, 48);
    }

    public double r747pner() {
        return Util.ConvertLongFPHex(this.data, 56);
    }

    public String r747pand() {
        return Util.ConvertEbcdic(this.data, 72, 32);
    }

    public static FcdPortDataSection create(byte[] Data2, int offset, int length) {
        return new FcdPortDataSection(Data2, offset, length);
    }

    static enum Field {
        r747pnum(0, 1),
        r747padr(1, 1),
        r747ptfl(2, 1),
        r747psfl(3, 1),
        r747pcu(4, 2),
        r747pcp(5, 1),
        r747pcun(6, 1),
        r747pnpc(7, 1),
        r747pxpc(8, 2),
        r747ppfl(10, 1),
        r747pfpt(16, 8),
        r747pnwr(24, 8),
        r747pnwt(32, 8),
        r747pnfr(40, 8),
        r747pnft(48, 8),
        r747pner(56, 8),
        r747pand(72, 32);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

