/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype9;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZonedDateTime;

public final class PcieFunctionDataSection
extends SmfData {
    public static final int R749ALLO = 128;
    public static final int R749DEPG = 64;
    public static final int R749PERR = 32;
    public static final int R749DEAL = 128;
    public static final int R749REAL = 64;
    public static final int R749PNVA = 128;
    public static final int R749PFTV = 64;
    public static final int R749PORI = 32;
    public static final int R749GPRE = 16;

    private PcieFunctionDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long r749pfid() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public int r749pffl() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public boolean r749allo() {
        return Util.ConvertFlag(this.data, this.r749pffl(), 128, Field.r749pffl.length, 0);
    }

    public boolean r749depg() {
        return Util.ConvertFlag(this.data, this.r749pffl(), 64, Field.r749pffl.length, 0);
    }

    public boolean r749perr() {
        return Util.ConvertFlag(this.data, this.r749pffl(), 32, Field.r749pffl.length, 0);
    }

    public int r749pff1() {
        return Util.ConvertUnsignedBinary2(this.data, 6);
    }

    public boolean r749deal() {
        return Util.ConvertFlag(this.data, this.r749pff1(), 128, Field.r749pff1.length, 0);
    }

    public boolean r749real() {
        return Util.ConvertFlag(this.data, this.r749pff1(), 64, Field.r749pff1.length, 0);
    }

    public Duration r749errt() {
        return Util.Binary4MS(this.data, 8);
    }

    public double r749errtSeconds() {
        return Util.ToSeconds(this.r749errt());
    }

    public long r749errtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long r749devt() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public String r749devn() {
        return Util.ConvertEbcdic(this.data, 16, 24);
    }

    public String r749jobn() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public int r749asid() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int r749pcid() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public ZonedDateTime r749atst() {
        return Util.Binary8xStckTime(this.data, 52);
    }

    public BigInteger r749atstRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public Duration r749allt() {
        return Util.Binary4MS(this.data, 60);
    }

    public double r749alltSeconds() {
        return Util.ToSeconds(this.r749allt());
    }

    public long r749alltRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long r749scnt() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long r749loop() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger r749loopAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long r749stop() {
        return Util.ConvertUnsignedBinary8(this.data, 80);
    }

    public BigInteger r749stopAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public long r749sbop() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger r749sbopAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public long r749rfop() {
        return Util.ConvertUnsignedBinary8(this.data, 96);
    }

    public BigInteger r749rfopAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public int r749dmao() {
        return Util.ConvertUnsignedBinary2(this.data, 104);
    }

    public int r749dman() {
        return Util.ConvertUnsignedBinary2(this.data, 106);
    }

    public int r749fpfo() {
        return Util.ConvertUnsignedBinary2(this.data, 108);
    }

    public int r749fpfn() {
        return Util.ConvertUnsignedBinary2(this.data, 110);
    }

    public int r749fp1o() {
        return Util.ConvertUnsignedBinary2(this.data, 112);
    }

    public int r749fp1n() {
        return Util.ConvertUnsignedBinary2(this.data, 114);
    }

    public int r749flag() {
        return Util.ConvertUnsignedBinary1(this.data, 116);
    }

    public boolean r749pnva() {
        return Util.ConvertFlag(this.data, this.r749flag(), 128);
    }

    public boolean r749pftv() {
        return Util.ConvertFlag(this.data, this.r749flag(), 64);
    }

    public boolean r749pori() {
        return Util.ConvertFlag(this.data, this.r749flag(), 32);
    }

    public boolean r749gpre() {
        return Util.ConvertFlag(this.data, this.r749flag(), 16);
    }

    public int r749port() {
        if (this.data.length <= 149 && this.data.length != Field.r749port.offset + Field.r749port.length && this.data.length != Field.r749pft.offset + Field.r749pft.length && this.data.length != Field.r749net1.offset + Field.r749net1.length) {
            throw new IllegalArgumentException("Record appears to be incorrect version, data.length = " + Integer.toString(this.data.length));
        }
        return Util.ConvertUnsignedBinary1(this.data, 118);
    }

    public int r749pft() {
        if (this.data.length <= 149 && this.data.length != Field.r749pft.offset + Field.r749pft.length && this.data.length != Field.r749net1.offset + Field.r749net1.length) {
            throw new IllegalArgumentException("Record appears to be incorrect version, data.length = " + Integer.toString(this.data.length));
        }
        return Util.ConvertUnsignedBinary1(this.data, 119);
    }

    public String r749net1() {
        int location = 120;
        if (this.data.length <= 149) {
            location = 117;
        }
        return Util.ConvertEbcdic(this.data, location, 16);
    }

    public String r749net2() {
        int location = 136;
        if (this.data.length <= 149) {
            location = 133;
        }
        return Util.ConvertEbcdic(this.data, location, 16);
    }

    public String r749wwnn() {
        return Util.ConvertEbcdic(this.data, 152, 8);
    }

    public int r749sioo() {
        return Util.ConvertUnsignedBinary2(this.data, 160);
    }

    public int r749sion() {
        return Util.ConvertUnsignedBinary2(this.data, 162);
    }

    public int r749rtdo() {
        return Util.ConvertUnsignedBinary2(this.data, 164);
    }

    public int r749rtdn() {
        return Util.ConvertUnsignedBinary2(this.data, 166);
    }

    public int r749lkid() {
        return Util.ConvertUnsignedBinary2(this.data, 168);
    }

    public static PcieFunctionDataSection create(byte[] Data2, int offset, int length) {
        return new PcieFunctionDataSection(Data2, offset, length);
    }

    static enum Field {
        r749pfid(0, 4),
        r749pffl(4, 2),
        r749pff1(6, 2),
        r749errt(8, 4),
        r749devt(12, 4),
        r749devn(16, 24),
        r749jobn(40, 8),
        r749asid(48, 2),
        r749pcid(50, 2),
        r749atst(52, 8),
        r749allt(60, 4),
        r749scnt(68, 4),
        r749loop(72, 8),
        r749stop(80, 8),
        r749sbop(88, 8),
        r749rfop(96, 8),
        r749dmao(104, 2),
        r749dman(106, 2),
        r749fpfo(108, 2),
        r749fpfn(110, 2),
        r749fp1o(112, 2),
        r749fp1n(114, 2),
        r749flag(116, 1),
        r749port(118, 1),
        r749pft(119, 1),
        r749net1(120, 16),
        r749net2(136, 16),
        r749wwnn(152, 8),
        r749sioo(160, 2),
        r749sion(162, 2),
        r749rtdo(164, 2),
        r749rtdn(166, 2),
        r749lkid(168, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

