/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf75;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf75.Header;
import com.blackhillsoftware.smf.smf75.ProductSection;
import com.blackhillsoftware.smf.smf75.subtype1.PageDatasetDataSection;
import java.util.List;

public final class Smf75Record
extends SmfRecord {
    private static final CreateSection<ProductSection> buildProductSection = new CreateSection<ProductSection>(){

        @Override
        public ProductSection createSection(byte[] data, int offset, int length) {
            return ProductSection.create(data, offset, length);
        }
    };
    private static final CreateSection<PageDatasetDataSection> buildPageDatasetDataSection = new CreateSection<PageDatasetDataSection>(){

        @Override
        public PageDatasetDataSection createSection(byte[] data, int offset, int length) {
            return PageDatasetDataSection.create(data, offset, length);
        }
    };
    private static final int TRIPLETLENGTH = 8;
    private List<PageDatasetDataSection> m_pageDatasetDataSections = null;
    private Header m_header = null;
    private ProductSection m_productSection = null;

    public Smf75Record(byte[] data) {
        super(data);
        if (this.recordType() != 75) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf75Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 75) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf75Record from(SmfRecord record) {
        return new Smf75Record(record);
    }

    public static Smf75Record from(byte[] data) {
        return new Smf75Record(data);
    }

    public Header header() {
        if (this.m_header == null) {
            Header tempHeader = new Header(this.data);
            this.m_header = Header.create(this.data, 0, Header.Field.smf75prs.offset() + tempHeader.smf75trn() * 8);
        }
        return this.m_header;
    }

    public ProductSection productSection() {
        if (this.m_productSection == null) {
            Triplet t = Triplets.ProductSection.getTriplet(this.header());
            this.m_productSection = buildProductSection.createSection(this.data, t.getOffset(), t.getLength());
        }
        return this.m_productSection;
    }

    public List<PageDatasetDataSection> pageDatasetDataSections() {
        this.m_pageDatasetDataSections = Util.sectionsFromTriplet(this.m_pageDatasetDataSections, this.data, Triplets.PageDatasetDataSection.getTriplet(this.header()), buildPageDatasetDataSection);
        return this.m_pageDatasetDataSections;
    }

    private static enum Triplets {
        ProductSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf75prs(), header.smf75prl(), header.smf75prn());
            }
        }
        ,
        PageDatasetDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf75pss(), header.smf75psl(), header.smf75psn());
            }
        };


        abstract Triplet getTriplet(Header var1);
    }
}

