/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf77;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf77.Header;
import com.blackhillsoftware.smf.smf77.ProductSection;
import com.blackhillsoftware.smf.smf77.subtype1.EnqueueControlSection;
import com.blackhillsoftware.smf.smf77.subtype1.EnqueueDataSection;
import java.util.List;

public final class Smf77Record
extends SmfRecord {
    private static final CreateSection<ProductSection> buildProductSection = new CreateSection<ProductSection>(){

        @Override
        public ProductSection createSection(byte[] data, int offset, int length) {
            return ProductSection.create(data, offset, length);
        }
    };
    private static final CreateSection<EnqueueControlSection> buildEnqueueControlSection = new CreateSection<EnqueueControlSection>(){

        @Override
        public EnqueueControlSection createSection(byte[] data, int offset, int length) {
            return EnqueueControlSection.create(data, offset, length);
        }
    };
    private static final CreateSection<EnqueueDataSection> buildEnqueueDataSection = new CreateSection<EnqueueDataSection>(){

        @Override
        public EnqueueDataSection createSection(byte[] data, int offset, int length) {
            return EnqueueDataSection.create(data, offset, length);
        }
    };
    private static final int TRIPLETLENGTH = 8;
    private List<EnqueueControlSection> m_enqueueControlSections = null;
    private List<EnqueueDataSection> m_enqueueDataSections = null;
    private Header m_header = null;
    private ProductSection m_productSection = null;

    public Smf77Record(byte[] data) {
        super(data);
        if (this.recordType() != 77) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf77Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 77) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf77Record from(SmfRecord record) {
        return new Smf77Record(record);
    }

    public static Smf77Record from(byte[] data) {
        return new Smf77Record(data);
    }

    public Header header() {
        if (this.m_header == null) {
            Header tempHeader = new Header(this.data);
            this.m_header = Header.create(this.data, 0, Header.Field.smf77prs.offset() + tempHeader.smf77trn() * 8);
        }
        return this.m_header;
    }

    public ProductSection productSection() {
        if (this.m_productSection == null) {
            Triplet t = Triplets.ProductSection.getTriplet(this.header());
            this.m_productSection = buildProductSection.createSection(this.data, t.getOffset(), t.getLength());
        }
        return this.m_productSection;
    }

    public List<EnqueueControlSection> enqueueControlSections() {
        this.m_enqueueControlSections = Util.sectionsFromTriplet(this.m_enqueueControlSections, this.data, Triplets.EnqueueControlSection.getTriplet(this.header()), buildEnqueueControlSection);
        return this.m_enqueueControlSections;
    }

    public List<EnqueueDataSection> enqueueDataSections() {
        this.m_enqueueDataSections = Util.sectionsFromTriplet(this.m_enqueueDataSections, this.data, Triplets.EnqueueDataSection.getTriplet(this.header()), buildEnqueueDataSection);
        return this.m_enqueueDataSections;
    }

    private static enum Triplets {
        ProductSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf77prs(), header.smf77prl(), header.smf77prn());
            }
        }
        ,
        EnqueueControlSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf77eqs(), header.smf77eql(), header.smf77eqn());
            }
        }
        ,
        EnqueueDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf77eds(), header.smf77edl(), header.smf77edn());
            }
        };


        abstract Triplet getTriplet(Header var1);
    }
}

