/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf78;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMF78RRF = 128;
    public static final int SMF78SUT = 64;
    public static final int SMF78V4 = 16;
    public static final int SMF78ESA = 8;
    public static final int SMF78VXA = 4;
    public static final int SMF78OS = 2;
    public static final int SMF78BFY = 1;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Header(byte[] Data2) {
        super(Data2);
    }

    public int smf78len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf78seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf78flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf78rrf() {
        return Util.ConvertFlag(this.data, this.smf78flg(), 128);
    }

    public boolean smf78sut() {
        return Util.ConvertFlag(this.data, this.smf78flg(), 64);
    }

    public boolean smf78v4() {
        return Util.ConvertFlag(this.data, this.smf78flg(), 16);
    }

    public boolean smf78esa() {
        return Util.ConvertFlag(this.data, this.smf78flg(), 8);
    }

    public boolean smf78vxa() {
        return Util.ConvertFlag(this.data, this.smf78flg(), 4);
    }

    public boolean smf78os() {
        return Util.ConvertFlag(this.data, this.smf78flg(), 2);
    }

    public boolean smf78bfy() {
        return Util.ConvertFlag(this.data, this.smf78flg(), 1);
    }

    public int smf78rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf78tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf78tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf78dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf78dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf78sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf78ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf78sty() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf78trn() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf78prs() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    Triplet smf78prsTriplet() {
        return Triplet.get422Triplet(this.data, 28);
    }

    public int smf78prl() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf78prn() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf78dcs() {
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    Triplet smf78dcsTriplet() {
        return Triplet.get422Triplet(this.data, 36);
    }

    public int smf78dcl() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf78dcn() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf78ass() {
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    Triplet smf78assTriplet() {
        return Triplet.get422Triplet(this.data, 44);
    }

    public int smf78asl() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf78asn() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf78sps() {
        if (this.smf78sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf78sty() == 2");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    Triplet smf78spsTriplet() {
        return Triplet.get422Triplet(this.data, 52);
    }

    public int smf78qds() {
        if (this.smf78sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf78sty() == 3");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    Triplet smf78qdsTriplet() {
        return Triplet.get422Triplet(this.data, 52);
    }

    public int smf78spl() {
        if (this.smf78sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf78sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf78qdl() {
        if (this.smf78sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf78sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf78spn() {
        if (this.smf78sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf78sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf78qdn() {
        if (this.smf78sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf78sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf78hps() {
        if (this.smf78sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf78sty() == 3");
        }
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    Triplet smf78hpsTriplet() {
        return Triplet.get422Triplet(this.data, 60);
    }

    public int smf78hpl() {
        if (this.smf78sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf78sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf78hpn() {
        if (this.smf78sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf78sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf78len(0, 2),
        smf78seg(2, 2),
        smf78flg(4, 1),
        smf78rty(5, 1),
        smf78tme(6, 4),
        smf78dte(10, 4),
        smf78sid(14, 4),
        smf78ssi(18, 4),
        smf78sty(22, 2),
        smf78trn(24, 2),
        smf78prs(28, 4),
        smf78prl(32, 2),
        smf78prn(34, 2),
        smf78dcs(36, 4),
        smf78dcl(40, 2),
        smf78dcn(42, 2),
        smf78ass(44, 4),
        smf78asl(48, 2),
        smf78asn(50, 2),
        smf78sps(52, 4),
        smf78qds(52, 4),
        smf78spl(56, 2),
        smf78qdl(56, 2),
        smf78spn(58, 2),
        smf78qdn(58, 2),
        smf78hps(60, 4),
        smf78hpl(64, 2),
        smf78hpn(66, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

