/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf78;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf78.ReassemblyArea;
import com.blackhillsoftware.smf.values.BoostClass;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class ProductSection
extends SmfData {
    private ReassemblyArea m_reassemblyArea = null;
    public static final int SMF78CNV = 128;
    public static final int SMF78ISS = 64;
    public static final int SMF78M3R = 32;
    public static final int SMF78ISM = 16;
    public static final int SMF78RCL = 8;
    public static final int SMF78RCH = 4;
    public static final int SMF78AltVM = 2;
    public static final int SMF78IIP = 64;
    public static final int SMF78EED = 32;
    public static final int SMF78BOO = 7;
    public static final int SMF78QES = 128;
    public static final int SMF78CNE = 64;
    public static final int SMF78DRC = 32;
    public static final int SMF78EME = 16;
    public static final int SMF78PRI = 8;
    public static final int SMF78PRP = 4;
    public static final int SMF78PED = 2;
    public static final int SMF78PE2 = 1;

    private ProductSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ReassemblyArea reassemblyArea() {
        if (this.m_reassemblyArea == null && this.smf78ran() == 1) {
            this.m_reassemblyArea = ReassemblyArea.create(this.data, this.smf78rao(), this.smf78ral());
        }
        return this.m_reassemblyArea;
    }

    public int smf78mfv() {
        return Util.ConvertPacked2(this.data, 0);
    }

    public String smf78prd() {
        return Util.ConvertEbcdic(this.data, 2, 8);
    }

    public LocalTime smf78ist() {
        return Util.Packed_HHMMSS(this.data, 10);
    }

    public int smf78istRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public LocalDate smf78dat() {
        return Util.SMFDate(this.data, 14);
    }

    public int smf78datRawValue() {
        return Util.ConvertPacked4(this.data, 14);
    }

    public Duration smf78int() {
        return Util.Packed_MMSSTTT(this.data, 18);
    }

    public double smf78intSeconds() {
        return Util.ToSeconds(this.smf78int());
    }

    public int smf78intRawValue() {
        return Util.ConvertPacked4(this.data, 18);
    }

    public int smf78mfl() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long smf78sam() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int smf78rv2() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf78fla() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public boolean smf78cnv() {
        return Util.ConvertFlag(this.data, this.smf78fla(), 128, Field.smf78fla.length, 0);
    }

    public boolean smf78iss() {
        return Util.ConvertFlag(this.data, this.smf78fla(), 64, Field.smf78fla.length, 0);
    }

    public boolean smf78m3r() {
        return Util.ConvertFlag(this.data, this.smf78fla(), 32, Field.smf78fla.length, 0);
    }

    public boolean smf78ism() {
        return Util.ConvertFlag(this.data, this.smf78fla(), 16, Field.smf78fla.length, 0);
    }

    public boolean smf78rcl() {
        return Util.ConvertFlag(this.data, this.smf78fla(), 8, Field.smf78fla.length, 0);
    }

    public boolean smf78rch() {
        return Util.ConvertFlag(this.data, this.smf78fla(), 4, Field.smf78fla.length, 0);
    }

    public boolean smf78altVm() {
        return Util.ConvertFlag(this.data, this.smf78fla(), 2, Field.smf78fla.length, 0);
    }

    public boolean smf78iip() {
        return Util.ConvertFlag(this.data, this.smf78fla(), 64, Field.smf78fla.length, 1);
    }

    public boolean smf78eed() {
        return Util.ConvertFlag(this.data, this.smf78fla(), 32, Field.smf78fla.length, 1);
    }

    public BoostClass boostClass() {
        if (this.smf78iip() || this.smf78eed()) {
            return BoostClass.from(this.smf78fla() & 7);
        }
        return null;
    }

    public String smf78rls() {
        return Util.ConvertEbcdic(this.data, 32, 4);
    }

    public Duration smf78cyc() {
        return Util.Packed_MMSSTTT(this.data, 36);
    }

    public double smf78cycSeconds() {
        return Util.ToSeconds(this.smf78cyc());
    }

    public int smf78cycRawValue() {
        return Util.ConvertPacked4(this.data, 36);
    }

    public String smf78mvs() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public int smf78iml() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public int smf78prf() {
        return Util.ConvertUnsignedBinary1(this.data, 49);
    }

    public boolean smf78qes() {
        return Util.ConvertFlag(this.data, this.smf78prf(), 128);
    }

    public boolean smf78cne() {
        return Util.ConvertFlag(this.data, this.smf78prf(), 64);
    }

    public boolean smf78drc() {
        return Util.ConvertFlag(this.data, this.smf78prf(), 32);
    }

    public boolean smf78eme() {
        return Util.ConvertFlag(this.data, this.smf78prf(), 16);
    }

    public boolean smf78pri() {
        return Util.ConvertFlag(this.data, this.smf78prf(), 8);
    }

    public boolean smf78prp() {
        return Util.ConvertFlag(this.data, this.smf78prf(), 4);
    }

    public boolean smf78ped() {
        return Util.ConvertFlag(this.data, this.smf78prf(), 2);
    }

    public boolean smf78pe2() {
        return Util.ConvertFlag(this.data, this.smf78prf(), 1);
    }

    public int smf78ptn() {
        return Util.ConvertUnsignedBinary1(this.data, 50);
    }

    public int smf78srl() {
        return Util.ConvertUnsignedBinary1(this.data, 51);
    }

    public ZonedDateTime smf78iet() {
        return Util.Binary8xStckTime(this.data, 52);
    }

    public BigInteger smf78ietRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public ZoneOffset smf78lgo() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 60);
    }

    public long smf78lgoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 60);
    }

    public int smf78rao() {
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf78ral() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf78ran() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public Duration smf78oil() {
        return Util.Binary2Seconds(this.data, 76);
    }

    public double smf78oilSeconds() {
        return Util.ToSeconds(this.smf78oil());
    }

    public int smf78oilRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public Duration smf78syn() {
        return Util.Binary2Seconds(this.data, 78);
    }

    public double smf78synSeconds() {
        return Util.ToSeconds(this.smf78syn());
    }

    public int smf78synRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public ZonedDateTime smf78gie() {
        return Util.Binary8xStckTime(this.data, 80);
    }

    public BigInteger smf78gieRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public String smf78xnm() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public String smf78snm() {
        return Util.ConvertEbcdic(this.data, 96, 8);
    }

    public static ProductSection create(byte[] Data2, int offset, int length) {
        return new ProductSection(Data2, offset, length);
    }

    static enum Field {
        smf78mfv(0, 2),
        smf78prd(2, 8),
        smf78ist(10, 4),
        smf78dat(14, 4),
        smf78int(18, 4),
        smf78mfl(22, 2),
        smf78sam(24, 4),
        smf78rv2(28, 2),
        smf78fla(30, 2),
        smf78rls(32, 4),
        smf78cyc(36, 4),
        smf78mvs(40, 8),
        smf78iml(48, 1),
        smf78prf(49, 1),
        smf78ptn(50, 1),
        smf78srl(51, 1),
        smf78iet(52, 8),
        smf78lgo(60, 8),
        smf78rao(68, 4),
        smf78ral(72, 2),
        smf78ran(74, 2),
        smf78oil(76, 2),
        smf78syn(78, 2),
        smf78gie(80, 8),
        smf78xnm(88, 8),
        smf78snm(96, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

