/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf79;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf79.ReassemblyArea;
import com.blackhillsoftware.smf.values.BoostClass;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class ProductSection
extends SmfData {
    private ReassemblyArea m_reassemblyArea = null;
    public static final int SMF79CNV = 128;
    public static final int SMF79ISS = 64;
    public static final int SMF79M3R = 32;
    public static final int SMF79ISM = 16;
    public static final int SMF79RCL = 8;
    public static final int SMF79RCH = 4;
    public static final int SMF79AltVM = 2;
    public static final int SMF79IIP = 64;
    public static final int SMF79EED = 32;
    public static final int SMF79BOO = 7;
    public static final int SMF79QES = 128;
    public static final int SMF79CNE = 64;
    public static final int SMF79DRC = 32;
    public static final int SMF79EME = 16;
    public static final int SMF79PRI = 8;
    public static final int SMF79PRP = 4;
    public static final int SMF79PED = 2;
    public static final int SMF79PE2 = 1;

    private ProductSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ReassemblyArea reassemblyArea() {
        if (this.m_reassemblyArea == null && this.smf79ran() == 1) {
            this.m_reassemblyArea = ReassemblyArea.create(this.data, this.smf79rao(), this.smf79ral());
        }
        return this.m_reassemblyArea;
    }

    public int smf79mfv() {
        return Util.ConvertPacked2(this.data, 0);
    }

    public String smf79prd() {
        return Util.ConvertEbcdic(this.data, 2, 8);
    }

    public LocalTime smf79ist() {
        return Util.Packed_HHMMSS(this.data, 10);
    }

    public int smf79istRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public LocalDate smf79dat() {
        return Util.SMFDate(this.data, 14);
    }

    public int smf79datRawValue() {
        return Util.ConvertPacked4(this.data, 14);
    }

    public Duration smf79int() {
        return Util.Packed_MMSSTTT(this.data, 18);
    }

    public double smf79intSeconds() {
        return Util.ToSeconds(this.smf79int());
    }

    public int smf79intRawValue() {
        return Util.ConvertPacked4(this.data, 18);
    }

    public int smf79mfl() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long smf79sam() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int smf79rv2() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf79fla() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public boolean smf79cnv() {
        return Util.ConvertFlag(this.data, this.smf79fla(), 128, Field.smf79fla.length, 0);
    }

    public boolean smf79iss() {
        return Util.ConvertFlag(this.data, this.smf79fla(), 64, Field.smf79fla.length, 0);
    }

    public boolean smf79m3r() {
        return Util.ConvertFlag(this.data, this.smf79fla(), 32, Field.smf79fla.length, 0);
    }

    public boolean smf79ism() {
        return Util.ConvertFlag(this.data, this.smf79fla(), 16, Field.smf79fla.length, 0);
    }

    public boolean smf79rcl() {
        return Util.ConvertFlag(this.data, this.smf79fla(), 8, Field.smf79fla.length, 0);
    }

    public boolean smf79rch() {
        return Util.ConvertFlag(this.data, this.smf79fla(), 4, Field.smf79fla.length, 0);
    }

    public boolean smf79altVm() {
        return Util.ConvertFlag(this.data, this.smf79fla(), 2, Field.smf79fla.length, 0);
    }

    public boolean smf79iip() {
        return Util.ConvertFlag(this.data, this.smf79fla(), 64, Field.smf79fla.length, 1);
    }

    public boolean smf79eed() {
        return Util.ConvertFlag(this.data, this.smf79fla(), 32, Field.smf79fla.length, 1);
    }

    public BoostClass boostClass() {
        if (this.smf79iip() || this.smf79eed()) {
            return BoostClass.from(this.smf79fla() & 7);
        }
        return null;
    }

    public String smf79rls() {
        return Util.ConvertEbcdic(this.data, 32, 4);
    }

    public Duration smf79cyc() {
        return Util.Packed_MMSSTTT(this.data, 36);
    }

    public double smf79cycSeconds() {
        return Util.ToSeconds(this.smf79cyc());
    }

    public int smf79cycRawValue() {
        return Util.ConvertPacked4(this.data, 36);
    }

    public String smf79mvs() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public int smf79iml() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public int smf79prf() {
        return Util.ConvertUnsignedBinary1(this.data, 49);
    }

    public boolean smf79qes() {
        return Util.ConvertFlag(this.data, this.smf79prf(), 128);
    }

    public boolean smf79cne() {
        return Util.ConvertFlag(this.data, this.smf79prf(), 64);
    }

    public boolean smf79drc() {
        return Util.ConvertFlag(this.data, this.smf79prf(), 32);
    }

    public boolean smf79eme() {
        return Util.ConvertFlag(this.data, this.smf79prf(), 16);
    }

    public boolean smf79pri() {
        return Util.ConvertFlag(this.data, this.smf79prf(), 8);
    }

    public boolean smf79prp() {
        return Util.ConvertFlag(this.data, this.smf79prf(), 4);
    }

    public boolean smf79ped() {
        return Util.ConvertFlag(this.data, this.smf79prf(), 2);
    }

    public boolean smf79pe2() {
        return Util.ConvertFlag(this.data, this.smf79prf(), 1);
    }

    public int smf79ptn() {
        return Util.ConvertUnsignedBinary1(this.data, 50);
    }

    public int smf79srl() {
        return Util.ConvertUnsignedBinary1(this.data, 51);
    }

    public ZonedDateTime smf79iet() {
        return Util.Binary8xStckTime(this.data, 52);
    }

    public BigInteger smf79ietRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public ZoneOffset smf79lgo() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 60);
    }

    public long smf79lgoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 60);
    }

    public int smf79rao() {
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf79ral() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf79ran() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public Duration smf79oil() {
        return Util.Binary2Seconds(this.data, 76);
    }

    public double smf79oilSeconds() {
        return Util.ToSeconds(this.smf79oil());
    }

    public int smf79oilRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public Duration smf79syn() {
        return Util.Binary2Seconds(this.data, 78);
    }

    public double smf79synSeconds() {
        return Util.ToSeconds(this.smf79syn());
    }

    public int smf79synRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public ZonedDateTime smf79gie() {
        return Util.Binary8xStckTime(this.data, 80);
    }

    public BigInteger smf79gieRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public String smf79xnm() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public String smf79snm() {
        return Util.ConvertEbcdic(this.data, 96, 8);
    }

    public static ProductSection create(byte[] Data2, int offset, int length) {
        return new ProductSection(Data2, offset, length);
    }

    static enum Field {
        smf79mfv(0, 2),
        smf79prd(2, 8),
        smf79ist(10, 4),
        smf79dat(14, 4),
        smf79int(18, 4),
        smf79mfl(22, 2),
        smf79sam(24, 4),
        smf79rv2(28, 2),
        smf79fla(30, 2),
        smf79rls(32, 4),
        smf79cyc(36, 4),
        smf79mvs(40, 8),
        smf79iml(48, 1),
        smf79prf(49, 1),
        smf79ptn(50, 1),
        smf79srl(51, 1),
        smf79iet(52, 8),
        smf79lgo(60, 8),
        smf79rao(68, 4),
        smf79ral(72, 2),
        smf79ran(74, 2),
        smf79oil(76, 2),
        smf79syn(78, 2),
        smf79gie(80, 8),
        smf79xnm(88, 8),
        smf79snm(96, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

