/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf8;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMFRCD8 = 0;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf8len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf8seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf8flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf8rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf8tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf8tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf8dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf8dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf8sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public int smf8lenn() {
        return Util.ConvertUnsignedBinary2(this.data, 18);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf8len(0, 2),
        smf8seg(2, 2),
        smf8flg(4, 1),
        smf8rty(5, 1),
        smf8tme(6, 4),
        smf8dte(10, 4),
        smf8sid(14, 4),
        smf8lenn(18, 2),
        smf8dut(20, 2),
        smf8cha(22, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

