/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf8;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf8.DeviceDataSection;
import com.blackhillsoftware.smf.smf8.Header;
import java.util.List;

public final class Smf8Record
extends SmfRecord {
    private static final CreateSection<DeviceDataSection> buildDeviceDataSection = new CreateSection<DeviceDataSection>(){

        @Override
        public DeviceDataSection createSection(byte[] data, int offset, int length) {
            return new DeviceDataSection(data, offset, length);
        }
    };
    private Header m_header = null;
    private List<DeviceDataSection> m_deviceDataSections = null;

    public Smf8Record(byte[] data) {
        super(data);
        if (this.recordType() != 8) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf8Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 8) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf8Record from(SmfRecord record) {
        return new Smf8Record(record);
    }

    public static Smf8Record from(byte[] data) {
        return new Smf8Record(data);
    }

    public Header header() {
        if (this.m_header == null) {
            this.m_header = Header.create(this.data, 0, Header.Field.smf8lenn.offset() + Header.Field.smf8lenn.length());
        }
        return this.m_header;
    }

    public List<DeviceDataSection> deviceDataSections() {
        this.m_deviceDataSections = Util.sectionsFromTriplet(this.m_deviceDataSections, this.data, Triplets.DeviceDataSection.getTriplet(this.header()), buildDeviceDataSection);
        return this.m_deviceDataSections;
    }

    private static enum Triplets {
        DeviceDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(Header.Field.smf8lenn.offset() + Header.Field.smf8lenn.length(), DeviceDataSection.Field.smf8cha.length() + DeviceDataSection.Field.smf8dut.length(), (header.smf8lenn() - Header.Field.smf8lenn.length()) / (DeviceDataSection.Field.smf8cha.length() + DeviceDataSection.Field.smf8dut.length()));
            }
        };


        abstract Triplet getTriplet(Header var1);
    }
}

