/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf89;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMF89STPUSAGE = 1;
    public static final int SMF89STPPRODREG = 2;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Header(byte[] Data2) {
        super(Data2);
    }

    public int smf89len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf89seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf89flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf89rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf89tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf89tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf89dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf89dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf89sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf89wid() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf89stp() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public boolean smf89stpusage() {
        return Util.ConvertFlag(this.data, this.smf89stp(), 1);
    }

    public boolean smf89stpprodreg() {
        return Util.ConvertFlag(this.data, this.smf89stp(), 2);
    }

    public int smf89sdl() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    public int smf89pro() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf89prl() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf89prn() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf89sio() {
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf89sil() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf89sin() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf89udo() {
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf89udl() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf89udn() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public long smf89udr() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public int smf89cno() {
        return Util.ConvertSignedBinary4(this.data, 56);
    }

    public int smf89cnl() {
        return Util.ConvertUnsignedBinary2(this.data, 60);
    }

    public int smf89cnn() {
        return Util.ConvertUnsignedBinary2(this.data, 62);
    }

    public int smf89tro() {
        return Util.ConvertSignedBinary4(this.data, 64);
    }

    public int smf89trl() {
        return Util.ConvertUnsignedBinary2(this.data, 68);
    }

    public int smf89trn() {
        return Util.ConvertUnsignedBinary2(this.data, 70);
    }

    public int smf89tco() {
        return Util.ConvertSignedBinary4(this.data, 72);
    }

    public int smf89tcl() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public int smf89tcn() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf89len(0, 2),
        smf89seg(2, 2),
        smf89flg(4, 1),
        smf89rty(5, 1),
        smf89tme(6, 4),
        smf89dte(10, 4),
        smf89sid(14, 4),
        smf89wid(18, 4),
        smf89stp(22, 2),
        smf89sdl(24, 4),
        smf89pro(28, 4),
        smf89prl(32, 2),
        smf89prn(34, 2),
        smf89sio(36, 4),
        smf89sil(40, 2),
        smf89sin(42, 2),
        smf89udo(44, 4),
        smf89udl(48, 2),
        smf89udn(50, 2),
        smf89udr(52, 4),
        smf89cno(56, 4),
        smf89cnl(60, 2),
        smf89cnn(62, 2),
        smf89tro(64, 4),
        smf89trl(68, 2),
        smf89trn(70, 2),
        smf89tco(72, 4),
        smf89tcl(76, 2),
        smf89tcn(78, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

