/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf89;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf89.Header;
import com.blackhillsoftware.smf.smf89.ProductIntersectionData;
import com.blackhillsoftware.smf.smf89.ProductSection;
import com.blackhillsoftware.smf.smf89.StateData;
import com.blackhillsoftware.smf.smf89.SystemIdSection;
import com.blackhillsoftware.smf.smf89.TrgProductIntersectionData;
import com.blackhillsoftware.smf.smf89.TrgStateData;
import com.blackhillsoftware.smf.smf89.TrgUsageData;
import com.blackhillsoftware.smf.smf89.UsageData;
import java.util.List;

public final class Smf89Record
extends SmfRecord {
    private Header m_header = null;
    private ProductSection m_ProductSection = null;
    private SystemIdSection m_SystemId = null;
    private List<UsageData> m_UsageData = null;
    private List<ProductIntersectionData> m_ProductIntersectionData = null;
    private List<StateData> m_StateData = null;
    private List<TrgUsageData> m_TrgUsageData = null;
    private List<TrgProductIntersectionData> m_TrgProductIntersectionData = null;
    private List<TrgStateData> m_TrgStateData = null;

    public Smf89Record(byte[] data) {
        super(data);
        if (this.recordType() != 89) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf89Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 89) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf89Record from(SmfRecord record) {
        return new Smf89Record(record);
    }

    public static Smf89Record from(byte[] data) {
        return new Smf89Record(data);
    }

    public Header header() {
        if (this.m_header == null) {
            Header tempHeader = new Header(this.data);
            this.m_header = Header.create(this.data, 0, Header.Field.smf89pro.offset() + tempHeader.smf89sdl());
        }
        return this.m_header;
    }

    public ProductSection productSection() {
        if (this.m_ProductSection == null) {
            this.m_ProductSection = ProductSection.create(this.data, this.header().smf89pro(), this.header().smf89prl());
        }
        return this.m_ProductSection;
    }

    public SystemIdSection systemIdSection() {
        if (this.m_SystemId == null) {
            this.m_SystemId = SystemIdSection.create(this.data, this.header().smf89sio(), this.header().smf89sil());
        }
        return this.m_SystemId;
    }

    public List<UsageData> usageDataSections() {
        if (this.subType() != 1) {
            throw new NotAvailableException("This method is only supported for subtype 1)");
        }
        this.m_UsageData = Util.sectionsFromTriplet(this.m_UsageData, this.data, () -> this.header().smf89udo(), () -> this.header().smf89udl(), () -> this.header().smf89udn(), UsageData::create);
        return this.m_UsageData;
    }

    public List<ProductIntersectionData> productIntersectionData() {
        if (this.subType() != 1) {
            throw new NotAvailableException("This method is only supported for subtype 1)");
        }
        this.m_ProductIntersectionData = Util.sectionsFromTriplet(this.m_ProductIntersectionData, this.data, () -> this.header().smf89cno(), () -> this.header().smf89cnl(), () -> this.header().smf89cnn(), ProductIntersectionData::create);
        return this.m_ProductIntersectionData;
    }

    public List<StateData> stateData() {
        if (this.subType() != 2) {
            throw new NotAvailableException("This method is only supported for subtype 2)");
        }
        this.m_StateData = Util.sectionsFromTriplet(this.m_StateData, this.data, () -> this.header().smf89udo(), () -> this.header().smf89udl(), () -> this.header().smf89udn(), StateData::create);
        return this.m_StateData;
    }

    public List<TrgUsageData> trgUsageDataSections() {
        if (this.subType() != 1) {
            throw new NotAvailableException("This method is only supported for subtype 1)");
        }
        this.m_TrgUsageData = Util.sectionsFromTriplet(this.m_TrgUsageData, this.data, () -> this.header().smf89tro(), () -> this.header().smf89trl(), () -> this.header().smf89trn(), TrgUsageData::create);
        return this.m_TrgUsageData;
    }

    public List<TrgProductIntersectionData> trgProductIntersectionData() {
        if (this.subType() != 1) {
            throw new NotAvailableException("This method is only supported for subtype 1)");
        }
        this.m_TrgProductIntersectionData = Util.sectionsFromTriplet(this.m_TrgProductIntersectionData, this.data, () -> this.header().smf89tco(), () -> this.header().smf89tcl(), () -> this.header().smf89tcn(), TrgProductIntersectionData::create);
        return this.m_TrgProductIntersectionData;
    }

    public List<TrgStateData> trgStateData() {
        if (this.subType() != 2) {
            throw new NotAvailableException("This method is only supported for subtype 2)");
        }
        this.m_TrgStateData = Util.sectionsFromTriplet(this.m_TrgStateData, this.data, () -> this.header().smf89tro(), () -> this.header().smf89trl(), () -> this.header().smf89trn(), TrgStateData::create);
        return this.m_TrgStateData;
    }
}

