/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf89;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class TrgProductIntersectionData
extends SmfData {
    public static final int SMF89TCUC = 128;
    public static final int SMF89TCUP = 64;

    private TrgProductIntersectionData(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf89tccp() {
        return Util.ConvertEbcdic(this.data, 0, 56);
    }

    public String smf89tcpo() {
        return Util.ConvertEbcdic(this.data, 0, 16);
    }

    public String smf89tcpn() {
        return Util.ConvertEbcdic(this.data, 16, 16);
    }

    public String smf89tcpv() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public String smf89tcpq() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public String smf89tcpi() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public String smf89tcip() {
        return Util.ConvertEbcdic(this.data, 56, 56);
    }

    public String smf89tipo() {
        return Util.ConvertEbcdic(this.data, 56, 16);
    }

    public String smf89tipn() {
        return Util.ConvertEbcdic(this.data, 72, 16);
    }

    public String smf89tipv() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public String smf89tipq() {
        return Util.ConvertEbcdic(this.data, 96, 8);
    }

    public String smf89tipi() {
        return Util.ConvertEbcdic(this.data, 104, 8);
    }

    public String smf89tTrgName() {
        return Util.ConvertEbcdic(this.data, 112, 8);
    }

    public int smf89tcfg() {
        return Util.ConvertUnsignedBinary1(this.data, 120);
    }

    public boolean smf89tcuc() {
        return Util.ConvertFlag(this.data, this.smf89tcfg(), 128);
    }

    public boolean smf89tcup() {
        return Util.ConvertFlag(this.data, this.smf89tcfg(), 64);
    }

    public Duration smf89tcct() {
        return Util.LongFpHex_x100S(this.data, 128);
    }

    public double smf89tcctSeconds() {
        return Util.ToSeconds(this.smf89tcct());
    }

    public double smf89tcctRawValue() {
        return Util.ConvertLongFPHex(this.data, 128);
    }

    public Duration smf89tczt() {
        return Util.LongFpHex_x100S(this.data, 136);
    }

    public double smf89tcztSeconds() {
        return Util.ToSeconds(this.smf89tczt());
    }

    public double smf89tcztRawValue() {
        return Util.ConvertLongFPHex(this.data, 136);
    }

    public static TrgProductIntersectionData create(byte[] Data2, int offset, int length) {
        return new TrgProductIntersectionData(Data2, offset, length);
    }

    static enum Field {
        smf89tccp(0, 56),
        smf89tcpo(0, 16),
        smf89tcpn(16, 16),
        smf89tcpv(32, 8),
        smf89tcpq(40, 8),
        smf89tcpi(48, 8),
        smf89tcip(56, 56),
        smf89tipo(56, 16),
        smf89tipn(72, 16),
        smf89tipv(88, 8),
        smf89tipq(96, 8),
        smf89tipi(104, 8),
        smf89tTrgName(112, 8),
        smf89tcfg(120, 1),
        smf89tcct(128, 8),
        smf89tczt(136, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

