/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf89;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.values.BoostClass;
import java.math.BigInteger;
import java.time.Duration;

public final class UsageData
extends SmfData {
    public static final int SMF89UUN = 128;
    public static final int SMF89UNU = 64;
    public static final int SMF89UUS = 32;
    public static final int SMF89HCS = 128;
    public static final int SMF89AFS = 64;
    public static final int SMF89TSH = 32;
    public static final int SMF89PLV = 16;
    public static final int SMF89HTR = 8;
    public static final int SMF89_zIIPBoost_Active = 128;
    public static final int SMF89_SpeedBoost_Active = 64;
    public static final int SMF89_BoostClass_Mask = 7;

    private UsageData(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf89upo() {
        return Util.ConvertEbcdic(this.data, 0, 16);
    }

    public String smf89upn() {
        return Util.ConvertEbcdic(this.data, 16, 16);
    }

    public String smf89upv() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public String smf89upq() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public String smf89upi() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public Duration smf89uct() {
        return Util.LongFpHex_x100S(this.data, 56);
    }

    public double smf89uctSeconds() {
        return Util.ToSeconds(this.smf89uct());
    }

    public double smf89uctRawValue() {
        return Util.ConvertLongFPHex(this.data, 56);
    }

    public Duration smf89usr() {
        return Util.LongFpHex_x100S(this.data, 64);
    }

    public double smf89usrSeconds() {
        return Util.ToSeconds(this.smf89usr());
    }

    public double smf89usrRawValue() {
        return Util.ConvertLongFPHex(this.data, 64);
    }

    public int smf89ufg() {
        return Util.ConvertUnsignedBinary1(this.data, 72);
    }

    public boolean smf89uun() {
        return Util.ConvertFlag(this.data, this.smf89ufg(), 128);
    }

    public boolean smf89unu() {
        return Util.ConvertFlag(this.data, this.smf89ufg(), 64);
    }

    public boolean smf89uus() {
        return Util.ConvertFlag(this.data, this.smf89ufg(), 32);
    }

    public int smf89uf2() {
        return Util.ConvertUnsignedBinary1(this.data, 73);
    }

    public boolean smf89hcs() {
        return Util.ConvertFlag(this.data, this.smf89uf2(), 128);
    }

    public boolean smf89afs() {
        return Util.ConvertFlag(this.data, this.smf89uf2(), 64);
    }

    public boolean smf89tsh() {
        return Util.ConvertFlag(this.data, this.smf89uf2(), 32);
    }

    public boolean smf89plv() {
        return Util.ConvertFlag(this.data, this.smf89uf2(), 16);
    }

    public boolean smf89htr() {
        return Util.ConvertFlag(this.data, this.smf89uf2(), 8);
    }

    public int smf89BoostInfo() {
        return Util.ConvertUnsignedBinary1(this.data, 74);
    }

    public boolean smf89ziipBoostActive() {
        return Util.ConvertFlag(this.data, this.smf89BoostInfo(), 128);
    }

    public boolean smf89SpeedBoostActive() {
        return Util.ConvertFlag(this.data, this.smf89BoostInfo(), 64);
    }

    public BoostClass smf30BoostClass() {
        if (this.smf89ziipBoostActive() || this.smf89SpeedBoostActive()) {
            return BoostClass.from(this.smf89BoostInfo() & 7);
        }
        return null;
    }

    public int smf89urt() {
        return Util.ConvertUnsignedBinary1(this.data, 75);
    }

    public byte[] smf89urd() {
        if (this.data.length >= 84) {
            byte[] result = new byte[8];
            System.arraycopy(this.data, 76, result, 0, 8);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(76) + " Data length: " + Integer.toString(8));
    }

    public Duration smf89urdAsCpuTime() {
        if (this.smf89urt() != 1) {
            throw new NotAvailableException("This method is only supported when (smf89urt() == 1)");
        }
        return Util.LongFpHex_x100S(this.data, 76);
    }

    public long smf89urdAsBinary() {
        if (this.smf89urt() != 2) {
            throw new NotAvailableException("This method is only supported when (smf89urt() == 2)");
        }
        return Util.ConvertUnsignedBinary8(this.data, 76);
    }

    public BigInteger smf89urdAsBigInteger() {
        if (this.smf89urt() != 2) {
            throw new NotAvailableException("This method is only supported when (smf89urt() == 2)");
        }
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 76);
    }

    public double smf89urdLongFP() {
        if (this.smf89urt() != 3) {
            throw new NotAvailableException("This method is only supported when (smf89urt() == 3)");
        }
        return Util.ConvertLongFPHex(this.data, 76);
    }

    public Duration smf89uzt() {
        return Util.LongFpHex_x100S(this.data, 84);
    }

    public double smf89uztSeconds() {
        return Util.ToSeconds(this.smf89uzt());
    }

    public double smf89uztRawValue() {
        return Util.ConvertLongFPHex(this.data, 84);
    }

    public long smf89countAsTrad() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long smf89countAsTrg() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public static UsageData create(byte[] Data2, int offset, int length) {
        return new UsageData(Data2, offset, length);
    }

    static enum Field {
        smf89upo(0, 16),
        smf89upn(16, 16),
        smf89upv(32, 8),
        smf89upq(40, 8),
        smf89upi(48, 8),
        smf89uct(56, 8),
        smf89usr(64, 8),
        smf89ufg(72, 1),
        smf89uf2(73, 1),
        smf89BoostInfo(74, 1),
        smf89urt(75, 1),
        smf89urd(76, 8),
        smf89uzt(84, 8),
        smf89countAsTrad(92, 4),
        smf89countAsTrg(96, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

