/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class IplSrmSection
extends SmfData {
    private IplSrmSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf90ipt() {
        return Util.Binary8xStckTime(this.data, 0);
    }

    public BigInteger smf90iptRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public String smf90opt() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String smf90spn() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public ZonedDateTime smf90spt() {
        return Util.Binary8xStckTime(this.data, 40);
    }

    public BigInteger smf90sptRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public String smf90spu() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public String smf90sps() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public String smf90sdn() {
        return Util.ConvertEbcdic(this.data, 64, 8);
    }

    public ZonedDateTime smf90sdt() {
        return Util.Binary8xStckTime(this.data, 72);
    }

    public BigInteger smf90sdtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public String smf90sdu() {
        return Util.ConvertEbcdic(this.data, 80, 8);
    }

    public String smf90sds() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public static IplSrmSection create(byte[] Data2, int offset, int length) {
        return new IplSrmSection(Data2, offset, length);
    }

    static enum Field {
        smf90ipt(0, 8),
        smf90opt(16, 8),
        smf90spn(32, 8),
        smf90spt(40, 8),
        smf90spu(48, 8),
        smf90sps(56, 8),
        smf90sdn(64, 8),
        smf90sdt(72, 8),
        smf90sdu(80, 8),
        smf90sds(88, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

