/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.smf90.Smf90Record;
import com.blackhillsoftware.smf.smf90.WlmSchedulingEnvironmentSection;
import com.blackhillsoftware.svpse.SchedulingEnvironment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class SchedulingEnvironmentBuilder {
    private static Object lockSchedulingEnvironment = new Object();
    private static Map<Long, Map<Integer, WlmSchedulingEnvironmentSection>> schedulingEnvironmentSectionsByActivation = new HashMap<Long, Map<Integer, WlmSchedulingEnvironmentSection>>();
    private static Map<Long, Smf90Record> schedulingEnvironmentRecordsByActivation = new HashMap<Long, Smf90Record>();

    SchedulingEnvironmentBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Optional<Smf90Record> buildWlmSchedulingEnvironment(Smf90Record r90) {
        Object object = lockSchedulingEnvironment;
        synchronized (object) {
            int required = r90.wlmSchedulingEnvironmentSection().smf9032n();
            int sequence = r90.wlmSchedulingEnvironmentSection().smf9032s();
            Long identifier = r90.wlmSchedulingEnvironmentSection().smf9032i();
            if (!schedulingEnvironmentRecordsByActivation.containsKey(identifier) || sequence < schedulingEnvironmentRecordsByActivation.get(identifier).wlmSchedulingEnvironmentSection().smf9032s()) {
                schedulingEnvironmentRecordsByActivation.put(identifier, r90);
            }
            schedulingEnvironmentSectionsByActivation.computeIfAbsent(identifier, key -> new HashMap()).put(sequence, r90.wlmSchedulingEnvironmentSection());
            if (schedulingEnvironmentSectionsByActivation.get(identifier).size() < required) {
                return Optional.empty();
            }
            List sections = schedulingEnvironmentSectionsByActivation.get(identifier).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(x -> (WlmSchedulingEnvironmentSection)x.getValue()).collect(Collectors.toList());
            int totalLength = sections.stream().map(x -> x.smf9032a().length).collect(Collectors.summingInt(Integer::intValue));
            byte[] combined = new byte[totalLength];
            int next = 1;
            int offset = 0;
            for (WlmSchedulingEnvironmentSection section : sections) {
                if (section.smf9032s() != next) continue;
                System.arraycopy(section.smf9032a(), 0, combined, offset, section.smf9032a().length);
                offset += section.smf9032a().length;
                ++next;
            }
            Smf90Record withPolicy = schedulingEnvironmentRecordsByActivation.get(((WlmSchedulingEnvironmentSection)sections.get(0)).smf9032i());
            withPolicy.set_m_SchedulingEnvironment(SchedulingEnvironment.create(combined, 0, combined.length, true));
            schedulingEnvironmentSectionsByActivation.remove(identifier);
            schedulingEnvironmentRecordsByActivation.remove(identifier);
            return Optional.of(withPolicy);
        }
    }

    static List<Smf90Record> buildWlmSchedulingEnvironment(Iterable<Smf90Record> records) {
        ArrayList<Smf90Record> result = new ArrayList<Smf90Record>();
        HashMap<Long, List> sectionsByPolicyChange = new HashMap<Long, List>();
        HashMap<Long, Smf90Record> recordsByPolicyChange = new HashMap<Long, Smf90Record>();
        for (Smf90Record r90 : records) {
            if (r90.subType() != 32) {
                result.add(r90);
                continue;
            }
            if (!recordsByPolicyChange.containsKey(r90.wlmSchedulingEnvironmentSection().smf9032i()) || r90.wlmSchedulingEnvironmentSection().smf9032s() < ((Smf90Record)recordsByPolicyChange.get(r90.wlmSchedulingEnvironmentSection().smf9032i())).wlmSchedulingEnvironmentSection().smf9032s()) {
                recordsByPolicyChange.put(r90.wlmSchedulingEnvironmentSection().smf9032i(), r90);
            }
            sectionsByPolicyChange.computeIfAbsent(r90.wlmSchedulingEnvironmentSection().smf9032i(), key -> new ArrayList()).add(r90.wlmSchedulingEnvironmentSection());
        }
        for (List sections : sectionsByPolicyChange.values()) {
            sections.sort(Comparator.comparing(WlmSchedulingEnvironmentSection::smf9032s));
            boolean complete = false;
            int totalLength = sections.stream().map(x -> x.smf9032a().length).collect(Collectors.summingInt(Integer::intValue));
            byte[] combined = new byte[totalLength];
            int next = 1;
            int offset = 0;
            for (WlmSchedulingEnvironmentSection section : sections) {
                if (section.smf9032s() == next) {
                    System.arraycopy(section.smf9032a(), 0, combined, offset, section.smf9032a().length);
                    offset += section.smf9032a().length;
                    ++next;
                }
                if (next <= section.smf9032n()) continue;
                complete = true;
            }
            Smf90Record withPolicy = (Smf90Record)recordsByPolicyChange.get(((WlmSchedulingEnvironmentSection)sections.get(0)).smf9032i());
            withPolicy.set_m_SchedulingEnvironment(SchedulingEnvironment.create(combined, 0, combined.length, complete));
            result.add(withPolicy);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Smf90Record> incompleteSchedulingEnvironmentRecords() {
        Object object = lockSchedulingEnvironment;
        synchronized (object) {
            ArrayList<Smf90Record> result = new ArrayList<Smf90Record>(schedulingEnvironmentRecordsByActivation.values());
            schedulingEnvironmentRecordsByActivation.clear();
            schedulingEnvironmentSectionsByActivation.clear();
            return result;
        }
    }
}

