/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SmfSubsystemRecordSection
extends SmfData {
    private List<Boolean> m_smf90sys = null;
    private static final int MAXEXITS = 15;
    private static final int EXITNAMELENGTH = 8;
    List<String> m_smf90exn = null;
    private List<Boolean> m_smf90sye = null;
    List<Integer> m_enabledTypes = null;

    private SmfSubsystemRecordSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf90wkn() {
        return Util.ConvertEbcdic(this.data, 0, 4);
    }

    public int smf90dtl() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public Duration smf90svl() {
        return Util.Binary8StckInterval(this.data, 8);
    }

    public double smf90svlSeconds() {
        return Util.ToSeconds(this.smf90svl());
    }

    public long smf90svlRawValue() {
        return Util.ConvertSignedBinary8(this.data, 8);
    }

    public List<Boolean> smf90sys() {
        if (this.m_smf90sys != null) {
            return this.m_smf90sys;
        }
        if (this.data.length >= Field.smf90sys.offset + Field.smf90sys.length) {
            ArrayList<Boolean> result = new ArrayList<Boolean>(256);
            for (int i = 0; i < Field.smf90sys.length; ++i) {
                int mask = 128;
                for (int j = 0; j < 8; ++j) {
                    int ix = i * 8 + j;
                    result.add((this.data[Field.smf90sys.offset + i] & mask) != 0);
                    mask >>= 1;
                }
            }
            this.m_smf90sys = Collections.unmodifiableList(result);
            return this.m_smf90sys;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(16) + " Data length: " + Integer.toString(32));
    }

    public List<String> smf90exn() {
        if (this.m_smf90exn != null) {
            return this.m_smf90exn;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < 15 && Util.ConvertSignedBinary8(this.data, Field.smf90exn.offset + i * 8) != 0L; ++i) {
            result.add(Util.ConvertEbcdic(this.data, Field.smf90exn.offset + i * 8, 8));
        }
        this.m_smf90exn = Collections.unmodifiableList(result);
        return this.m_smf90exn;
    }

    public List<Boolean> smf90sye() {
        if (this.m_smf90sye != null) {
            return this.m_smf90sye;
        }
        if (this.data.length >= 424) {
            ArrayList<Boolean> result = new ArrayList<Boolean>(2048);
            for (int i = 0; i < 256; ++i) {
                int mask = 128;
                for (int j = 0; j < 8; ++j) {
                    int ix = i * 8 + j;
                    result.add((this.data[Field.smf90sye.offset + i] & mask) != 0);
                    mask >>= 1;
                }
            }
            this.m_smf90sye = Collections.unmodifiableList(result);
            return this.m_smf90sye;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(168) + " Data length: " + Integer.toString(256));
    }

    public boolean enabledType(int smfType) {
        if (smfType < 0 || smfType > 2047) {
            throw new IllegalArgumentException(String.format("Invalid record number: %d. SMF record type must be between 0 and 2047", smfType));
        }
        int arrayOffset = smfType / 8;
        int bit = smfType % 8;
        int mask = 128 >> bit;
        if (this.length() >= Field.smf90sye.offset + Field.smf90sye.length) {
            return (this.data[Field.smf90sye.offset + arrayOffset] & mask) != 0;
        }
        if (this.data.length >= Field.smf90sys.offset + Field.smf90sys.length) {
            if (smfType > 255) {
                return false;
            }
            return (this.data[Field.smf90sys.offset + arrayOffset] & mask) != 0;
        }
        throw new IndexOutOfBoundsException("Field is outside the bounds of the data. Field offset: " + Integer.toString(16) + " Data length: " + Integer.toString(32));
    }

    public List<Integer> enabledTypes() {
        if (this.m_enabledTypes != null) {
            return this.m_enabledTypes;
        }
        if (this.length() >= Field.smf90sye.offset + Field.smf90sye.length) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (int i = 0; i < Field.smf90sye.length; ++i) {
                int mask = 128;
                for (int j = 0; j < 8; ++j) {
                    int ix = i * 8 + j;
                    if ((this.data[Field.smf90sye.offset + i] & mask) != 0) {
                        result.add(ix);
                    }
                    mask >>= 1;
                }
            }
            this.m_enabledTypes = Collections.unmodifiableList(result);
            return this.m_enabledTypes;
        }
        if (this.data.length >= Field.smf90sys.offset + Field.smf90sys.length) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (int i = 0; i < Field.smf90sys.length; ++i) {
                int mask = 128;
                for (int j = 0; j < 8; ++j) {
                    int ix = i * 8 + j;
                    if ((this.data[Field.smf90sys.offset + i] & mask) != 0) {
                        result.add(ix);
                    }
                    mask >>= 1;
                }
            }
            this.m_enabledTypes = Collections.unmodifiableList(result);
            return this.m_enabledTypes;
        }
        throw new IndexOutOfBoundsException("Field is outside the bounds of the data. Field offset: " + Integer.toString(16) + " Data length: " + Integer.toString(32));
    }

    public static SmfSubsystemRecordSection create(byte[] Data2, int offset, int length) {
        return new SmfSubsystemRecordSection(Data2, offset, length);
    }

    static enum Field {
        smf90wkn(0, 4),
        smf90dtl(4, 1),
        smf90svl(8, 8),
        smf90sys(16, 32),
        smf90exn(48, 120),
        smf90sye(168, 256);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

