/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.Token;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf90.CertFailureReason;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class ValidatedBootBadCX
extends SmfData {
    private ValidatedBootBadCX(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf90t42BcxCertName() {
        return Util.ConvertEbcdic(this.data, 0, 64);
    }

    public Token smf90t42BcxCertFP() {
        if (this.data.length >= 96) {
            return new Token(this.data, 64, 32);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(64) + " Data length: " + Integer.toString(32));
    }

    public Token smf90t42BcxKeyID() {
        if (this.data.length >= 116) {
            return new Token(this.data, 96, 20);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(96) + " Data length: " + Integer.toString(20));
    }

    public ZonedDateTime smf90t42BcxStartTime() {
        return Util.Binary8HiStckeTime(this.data, 116);
    }

    public BigInteger smf90t42BcxStartTimeRawValue() {
        return Util.ConvertBigInteger(this.data, 116, 8);
    }

    public ZonedDateTime smf90t42BcxExpirationTime() {
        return Util.Binary8HiStckeTime(this.data, 124);
    }

    public BigInteger smf90t42BcxExpirationTimeRawValue() {
        return Util.ConvertBigInteger(this.data, 124, 8);
    }

    public CertFailureReason smf90t42BcxReasonBad() {
        int value = Util.ConvertSignedBinary4(this.data, 132);
        return CertFailureReason.from(value);
    }

    public int smf90t42BcxReasonBadRawValue() {
        return Util.ConvertSignedBinary4(this.data, 132);
    }

    public static ValidatedBootBadCX create(byte[] Data2, int offset, int length) {
        return new ValidatedBootBadCX(Data2, offset, length);
    }

    static enum Field {
        smf90t42BcxCertName(0, 64),
        smf90t42BcxCertFP(64, 32),
        smf90t42BcxKeyID(96, 20),
        smf90t42BcxStartTime(116, 8),
        smf90t42BcxExpirationTime(124, 8),
        smf90t42BcxReasonBad(132, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

