/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.Token;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf90.CertFailureReason;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class ValidatedBootCX
extends SmfData {
    private ValidatedBootCX(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf90t42CxCertName() {
        return Util.ConvertEbcdic(this.data, 0, 64);
    }

    public Token smf90t42CxCertFP() {
        if (this.data.length >= 96) {
            return new Token(this.data, 64, 32);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(64) + " Data length: " + Integer.toString(32));
    }

    public Token smf90t42CxKeyID() {
        if (this.data.length >= 116) {
            return new Token(this.data, 96, 20);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(96) + " Data length: " + Integer.toString(20));
    }

    public long smf90t42CxNumSuccessfulUses() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public ZonedDateTime smf90t42CxStartTime() {
        return Util.Binary8HiStckeTime(this.data, 120);
    }

    public BigInteger smf90t42CxStartTimeRawValue() {
        return Util.ConvertBigInteger(this.data, 120, 8);
    }

    public ZonedDateTime smf90t42CxExpirationTime() {
        return Util.Binary8HiStckeTime(this.data, 128);
    }

    public BigInteger smf90t42CxExpirationTimeRawValue() {
        return Util.ConvertBigInteger(this.data, 128, 8);
    }

    public CertFailureReason smf90t42CxReasonBad() {
        int value = Util.ConvertSignedBinary4(this.data, 136);
        return CertFailureReason.from(value);
    }

    public int smf90t42CxReasonBadRawValue() {
        return Util.ConvertSignedBinary4(this.data, 136);
    }

    public static ValidatedBootCX create(byte[] Data2, int offset, int length) {
        return new ValidatedBootCX(Data2, offset, length);
    }

    static enum Field {
        smf90t42CxCertName(0, 64),
        smf90t42CxCertFP(64, 32),
        smf90t42CxKeyID(96, 20),
        smf90t42CxNumSuccessfulUses(116, 4),
        smf90t42CxStartTime(120, 8),
        smf90t42CxExpirationTime(128, 8),
        smf90t42CxReasonBad(136, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

