/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.CallCountsEntry;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CallCounts
extends SmfData {
    private List<CallCountsEntry> _callcountsentries = null;
    public static final int SMF92ST1_LEN = 24;

    private CallCounts(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92cct() {
        return Util.Binary16StckeTime(this.data, 0);
    }

    public BigInteger smf92cctRawValue() {
        return Util.ConvertBigInteger(this.data, 0, 16);
    }

    public int smf92ccc() {
        return Util.ConvertSignedBinary4(this.data, 16);
    }

    public List<CallCountsEntry> callCountsEntries() {
        if (this._callcountsentries == null) {
            ArrayList<CallCountsEntry> list = new ArrayList<CallCountsEntry>(this.smf92ccc());
            for (int i = 0; i < this.smf92ccc(); ++i) {
                list.add(CallCountsEntry.create(this.data, 24 + i * this.smf92ccl(), this.smf92ccl()));
            }
            this._callcountsentries = Collections.unmodifiableList(list);
        }
        return this._callcountsentries;
    }

    public int smf92ccl() {
        return Util.ConvertSignedBinary4(this.data, 20);
    }

    public static CallCounts create(byte[] Data2, int offset, int length) {
        return new CallCounts(Data2, offset, length);
    }

    static enum Field {
        smf92cct(0, 16),
        smf92ccc(16, 4),
        smf92ccl(20, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

