/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.FileSystemType;
import com.blackhillsoftware.smf.smf92.MntEntFsMode;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class FileSystemResume
extends SmfData {
    public static final int SMF92RLU = 128;
    public static final int SMF92RNU = 64;
    public static final int SMF92RDO = 32;
    public static final int SMF92RSN = 16;

    private FileSystemResume(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92rts() {
        return Util.Binary8xStckTime(this.data, 0);
    }

    public BigInteger smf92rtsRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public ZonedDateTime smf92rtr() {
        return Util.Binary8xStckTime(this.data, 8);
    }

    public BigInteger smf92rtrRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public FileSystemType smf92rft() {
        return FileSystemType.fromValue(this.smf92rftRawValue());
    }

    public long smf92rftRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public MntEntFsMode smf92rfm() {
        return MntEntFsMode.create(this.data, Field.smf92rfm.offset, Field.smf92rfm.length);
    }

    public long smf92rfmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smf92rdn() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public String smf92rdd() {
        return Util.ConvertEbcdic(this.data, 28, 8);
    }

    public String smf92rtn() {
        return Util.ConvertEbcdic(this.data, 36, 8);
    }

    public String smf92rfn() {
        return Util.ConvertEbcdic(this.data, 44, 44);
    }

    public int smf92rfg() {
        return Util.ConvertUnsignedBinary1(this.data, 88);
    }

    public boolean smf92rlu() {
        return Util.ConvertFlag(this.data, this.smf92rfg(), 128);
    }

    public boolean smf92rnu() {
        return Util.ConvertFlag(this.data, this.smf92rfg(), 64);
    }

    public boolean smf92rdo() {
        return Util.ConvertFlag(this.data, this.smf92rfg(), 32);
    }

    public boolean smf92rsn() {
        return Util.ConvertFlag(this.data, this.smf92rfg(), 16);
    }

    public static FileSystemResume create(byte[] Data2, int offset, int length) {
        return new FileSystemResume(Data2, offset, length);
    }

    static enum Field {
        smf92rts(0, 8),
        smf92rtr(8, 8),
        smf92rft(16, 4),
        smf92rfm(20, 4),
        smf92rdn(24, 4),
        smf92rdd(28, 8),
        smf92rtn(36, 8),
        smf92rfn(44, 44),
        smf92rfg(88, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

