/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.SubcomponentStorageUsageEntry;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MemoryUsage
extends SmfData {
    private List<SubcomponentStorageUsageEntry> _subcomponentStorageUsageEntry = null;
    public static final int SMF92ST7_LEN = 100;

    private MemoryUsage(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92sttt() {
        return Util.Binary16StckeTime(this.data, 0);
    }

    public BigInteger smf92stttRawValue() {
        return Util.ConvertBigInteger(this.data, 0, 16);
    }

    public long smf92sttab() {
        return Util.ConvertUnsignedBinary8(this.data, 16);
    }

    public BigInteger smf92sttabAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public long smf92ttbb() {
        return Util.ConvertUnsignedBinary8(this.data, 24);
    }

    public BigInteger smf92ttbbAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public long smf92thaa() {
        return Util.ConvertUnsignedBinary8(this.data, 32);
    }

    public BigInteger smf92thaaAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public long smf92thab() {
        return Util.ConvertUnsignedBinary8(this.data, 40);
    }

    public BigInteger smf92thabAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public long smf92thpa() {
        return Util.ConvertUnsignedBinary8(this.data, 48);
    }

    public BigInteger smf92thpaAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long smf92thpb() {
        return Util.ConvertUnsignedBinary8(this.data, 56);
    }

    public BigInteger smf92thpbAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public long smf92thara() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger smf92tharaAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long smf92thba() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger smf92thbaAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long smf92thar() {
        return Util.ConvertUnsignedBinary8(this.data, 80);
    }

    public BigInteger smf92tharAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public long smf92thbr() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger smf92thbrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public int smf92thcc() {
        return Util.ConvertUnsignedBinary2(this.data, 96);
    }

    public int smf92thcl() {
        return Util.ConvertUnsignedBinary2(this.data, 98);
    }

    public List<SubcomponentStorageUsageEntry> subcomponentStorageUsageEntries() {
        if (this._subcomponentStorageUsageEntry == null) {
            ArrayList<SubcomponentStorageUsageEntry> list = new ArrayList<SubcomponentStorageUsageEntry>(this.smf92thcc());
            for (int i = 0; i < this.smf92thcc(); ++i) {
                list.add(SubcomponentStorageUsageEntry.create(this.data, 100 + i * this.smf92thcl(), this.smf92thcl()));
            }
            this._subcomponentStorageUsageEntry = Collections.unmodifiableList(list);
        }
        return this._subcomponentStorageUsageEntry;
    }

    public static MemoryUsage create(byte[] Data2, int offset, int length) {
        return new MemoryUsage(Data2, offset, length);
    }

    static enum Field {
        smf92sttt(0, 16),
        smf92sttab(16, 8),
        smf92ttbb(24, 8),
        smf92thaa(32, 8),
        smf92thab(40, 8),
        smf92thpa(48, 8),
        smf92thpb(56, 8),
        smf92thara(64, 8),
        smf92thba(72, 8),
        smf92thar(80, 8),
        smf92thbr(88, 8),
        smf92thcc(96, 2),
        smf92thcl(98, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

