/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.PerSystemTokenUsageEntry;
import com.blackhillsoftware.smf.smf92.ThrashingFileEntry;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TokenManagerInformation
extends SmfData {
    private List<PerSystemTokenUsageEntry> _perSystemTokenUsageEntry = null;
    private List<ThrashingFileEntry> _thrashingFileEntry = null;
    public static final int SMF92ST6_LEN = 112;

    private TokenManagerInformation(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92tmt() {
        return Util.Binary16StckeTime(this.data, 0);
    }

    public BigInteger smf92tmtRawValue() {
        return Util.ConvertBigInteger(this.data, 0, 16);
    }

    public long smf92tmmx() {
        return Util.ConvertUnsignedBinary8(this.data, 16);
    }

    public BigInteger smf92tmmxAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public long smf92tmal() {
        return Util.ConvertUnsignedBinary8(this.data, 24);
    }

    public BigInteger smf92tmalAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public long smf92tmus() {
        return Util.ConvertUnsignedBinary8(this.data, 32);
    }

    public BigInteger smf92tmusAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public long smf92tmfl() {
        return Util.ConvertUnsignedBinary8(this.data, 40);
    }

    public BigInteger smf92tmflAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public long smf92tmob() {
        return Util.ConvertUnsignedBinary8(this.data, 48);
    }

    public BigInteger smf92tmobAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long smf92tmrt() {
        return Util.ConvertUnsignedBinary8(this.data, 56);
    }

    public BigInteger smf92tmrtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public long smf92tmrv() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger smf92tmrvAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long smf92tmag() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger smf92tmagAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long smf92tmgc() {
        return Util.ConvertUnsignedBinary8(this.data, 80);
    }

    public BigInteger smf92tmgcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public long smf92tmth() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger smf92tmthAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public long smf92tmtr() {
        return Util.ConvertUnsignedBinary8(this.data, 96);
    }

    public BigInteger smf92tmtrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public int smf92tmsyc() {
        return Util.ConvertUnsignedBinary2(this.data, 104);
    }

    public int smf92tmsyl() {
        return Util.ConvertUnsignedBinary2(this.data, 106);
    }

    public int smf92tmthc() {
        return Util.ConvertUnsignedBinary2(this.data, 108);
    }

    public int smf92tmthl() {
        return Util.ConvertUnsignedBinary2(this.data, 110);
    }

    public List<PerSystemTokenUsageEntry> perSystemTokenUsageEntries() {
        if (this._perSystemTokenUsageEntry == null) {
            ArrayList<PerSystemTokenUsageEntry> list = new ArrayList<PerSystemTokenUsageEntry>(this.smf92tmsyc());
            for (int i = 0; i < this.smf92tmsyc(); ++i) {
                list.add(PerSystemTokenUsageEntry.create(this.data, 112 + i * this.smf92tmsyl(), this.smf92tmsyl()));
            }
            this._perSystemTokenUsageEntry = Collections.unmodifiableList(list);
        }
        return this._perSystemTokenUsageEntry;
    }

    public List<ThrashingFileEntry> thrashingFileEntries() {
        if (this._thrashingFileEntry == null) {
            ArrayList<ThrashingFileEntry> list = new ArrayList<ThrashingFileEntry>(this.smf92tmthc());
            for (int i = 0; i < this.smf92tmthc(); ++i) {
                list.add(ThrashingFileEntry.create(this.data, 112 + this.smf92tmsyc() * this.smf92tmsyl() + i * this.smf92tmthl(), this.smf92tmthl()));
            }
            this._thrashingFileEntry = Collections.unmodifiableList(list);
        }
        return this._thrashingFileEntry;
    }

    public static TokenManagerInformation create(byte[] Data2, int offset, int length) {
        return new TokenManagerInformation(Data2, offset, length);
    }

    static enum Field {
        smf92tmt(0, 16),
        smf92tmmx(16, 8),
        smf92tmal(24, 8),
        smf92tmus(32, 8),
        smf92tmfl(40, 8),
        smf92tmob(48, 8),
        smf92tmrt(56, 8),
        smf92tmrv(64, 8),
        smf92tmag(72, 8),
        smf92tmgc(80, 8),
        smf92tmth(88, 8),
        smf92tmtr(96, 8),
        smf92tmsyc(104, 2),
        smf92tmsyl(106, 2),
        smf92tmthc(108, 2),
        smf92tmthl(110, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

