/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.PerSystemTransmitReceiveEntry;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TransmitReceiveStatistics
extends SmfData {
    private List<PerSystemTransmitReceiveEntry> _perSystemTransmitReceiveEntry = null;
    public static final int SMF92ST8_LEN = 20;

    private TransmitReceiveStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92trt() {
        return Util.Binary16StckeTime(this.data, 0);
    }

    public BigInteger smf92trtRawValue() {
        return Util.ConvertBigInteger(this.data, 0, 16);
    }

    public int smf92trc() {
        return Util.ConvertUnsignedBinary2(this.data, 16);
    }

    public int smf92trl() {
        return Util.ConvertUnsignedBinary2(this.data, 18);
    }

    public List<PerSystemTransmitReceiveEntry> perSystemTransmitReceiveEntries() {
        if (this._perSystemTransmitReceiveEntry == null) {
            ArrayList<PerSystemTransmitReceiveEntry> list = new ArrayList<PerSystemTransmitReceiveEntry>(this.smf92trc());
            for (int i = 0; i < this.smf92trc(); ++i) {
                list.add(PerSystemTransmitReceiveEntry.create(this.data, 20 + i * this.smf92trl(), this.smf92trl()));
            }
            this._perSystemTransmitReceiveEntry = Collections.unmodifiableList(list);
        }
        return this._perSystemTransmitReceiveEntry;
    }

    public static TransmitReceiveStatistics create(byte[] Data2, int offset, int length) {
        return new TransmitReceiveStatistics(Data2, offset, length);
    }

    static enum Field {
        smf92trt(0, 16),
        smf92trc(16, 2),
        smf92trl(18, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

